/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AsPathSegmentParser;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.AggregatorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.GracefulRestartCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.MultiprotocolCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.graceful.restart.capability.TablesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ComplementaryTest {
    @Test
    public void testBGPParameter() {
        MultiprotocolCapability cap = new MultiprotocolCapabilityBuilder().setAfi(Ipv6AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build();
        CParameters tlv1 = new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setMultiprotocolCapability(cap).build()).build();
        MultiprotocolCapability cap1 = new MultiprotocolCapabilityBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build();
        CParameters tlv2 = new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setMultiprotocolCapability(cap1).build()).build();
        ArrayList<Tables> tt = new ArrayList<Tables>();
        tt.add(new TablesBuilder().setAfi(Ipv6AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build());
        tt.add(new TablesBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build());
        GracefulRestartCapability tlv3 = new GracefulRestartCapabilityBuilder().setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.FALSE)).setRestartTime(Integer.valueOf(0)).setTables(tt).build();
        CParameters tlv4 = new CParametersBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Long.valueOf(40L))).build()).build();
        Assert.assertFalse((boolean)tlv3.getRestartFlags().isRestartState());
        Assert.assertEquals((long)0L, (long)tlv3.getRestartTime().intValue());
        Assert.assertFalse((boolean)tlv1.equals(tlv2));
        Assert.assertNotSame((Object)tlv1.hashCode(), (Object)tlv3.hashCode());
        Assert.assertNotSame((Object)tlv2.toString(), (Object)tlv3.toString());
        Assert.assertEquals((Object)tlv3.getTables(), tt);
        Assert.assertEquals((Object)cap.getSafi(), (Object)cap1.getSafi());
        Assert.assertNotSame((Object)cap.getAfi(), (Object)cap1.getAfi());
        Assert.assertEquals((long)40L, (long)tlv4.getAs4BytesCapability().getAsNumber().getValue());
        Assert.assertEquals((Object)new CParametersBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Long.valueOf(40L))).build()).build(), (Object)tlv4);
    }

    @Test
    public void testBGPAggregatorImpl() {
        Aggregator ipv4 = new AggregatorBuilder().setAsNumber(new AsNumber(Long.valueOf(5524L))).setNetworkAddress(new Ipv4Address("124.55.42.1")).build();
        Aggregator ipv4i = new AggregatorBuilder().setAsNumber(new AsNumber(Long.valueOf(5525L))).setNetworkAddress(new Ipv4Address("124.55.42.1")).build();
        Assert.assertNotSame((Object)ipv4.hashCode(), (Object)ipv4i.hashCode());
        Assert.assertNotSame((Object)ipv4.getAsNumber(), (Object)ipv4i.getAsNumber());
        Assert.assertEquals((Object)ipv4.getNetworkAddress(), (Object)ipv4i.getNetworkAddress());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAsPathSegmentParserPrivateConstructor() throws Throwable {
        Constructor c = AsPathSegmentParser.class.getDeclaredConstructor(new Class[0]);
        c.setAccessible(true);
        try {
            c.newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

