/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.open.GracefulCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.GracefulRestartCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.graceful.restart.capability.Tables;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.graceful.restart.capability.TablesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class GracefulCapabilityHandlerTest {
    private BGPExtensionProviderContext ctx;

    @Before
    public void setUp() {
        this.ctx = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance();
    }

    @Test
    public void testGracefulCapabilityHandler() throws BGPDocumentedException, BGPParsingException {
        GracefulCapabilityHandler handler = new GracefulCapabilityHandler(this.ctx.getAddressFamilyRegistry(), this.ctx.getSubsequentAddressFamilyRegistry());
        byte[] capaBytes = new byte[]{64, 6, -128, 50, 0, 1, 1, -128};
        GracefulRestartCapabilityBuilder capaBuilder = new GracefulRestartCapabilityBuilder();
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.valueOf(true)));
        capaBuilder.setRestartTime(Integer.valueOf(50));
        TablesBuilder tablesBuilder = new TablesBuilder();
        tablesBuilder.setAfiFlags(new Tables.AfiFlags(Boolean.valueOf(true)));
        tablesBuilder.setAfi(Ipv4AddressFamily.class);
        tablesBuilder.setSafi(UnicastSubsequentAddressFamily.class);
        capaBuilder.setTables((List)Lists.newArrayList((Object[])new Tables[]{tablesBuilder.build()}));
        ByteBuf buffer = Unpooled.buffer((int)capaBytes.length);
        handler.serializeCapability(new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
        Assert.assertArrayEquals((byte[])capaBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), (Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes).slice(2, capaBytes.length - 2)));
        byte[] capaBytes2 = new byte[]{64, 6, 0, 0, 0, 1, 1, 0};
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.valueOf(false)));
        capaBuilder.setRestartTime(Integer.valueOf(0));
        tablesBuilder.setAfiFlags(new Tables.AfiFlags(Boolean.valueOf(false)));
        capaBuilder.setTables((List)Lists.newArrayList((Object[])new Tables[]{tablesBuilder.build()}));
        buffer.clear();
        handler.serializeCapability(new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
        Assert.assertArrayEquals((byte[])capaBytes2, (byte[])buffer.array());
        Assert.assertEquals((Object)new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), (Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes2).slice(2, capaBytes2.length - 2)));
        capaBuilder.setRestartFlags(null);
        tablesBuilder.setAfiFlags(null);
        capaBuilder.setRestartTime(null);
        capaBuilder.setTables((List)Lists.newArrayList((Object[])new Tables[]{tablesBuilder.build()}));
        buffer.clear();
        handler.serializeCapability(new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
        Assert.assertArrayEquals((byte[])capaBytes2, (byte[])buffer.array());
        byte[] capaBytes3 = new byte[]{64, 6, 0, 0, 0, 0, 0, 0};
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.valueOf(false)));
        capaBuilder.setRestartTime(Integer.valueOf(0));
        capaBuilder.setTables(Collections.emptyList());
        Assert.assertEquals((Object)new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), (Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes3).slice(2, capaBytes3.length - 2)));
        byte[] capaBytes4 = new byte[]{64, 6, 0, 0, 0, 1, 0, 0};
        Assert.assertEquals((Object)new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), (Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes4).slice(2, capaBytes4.length - 2)));
        byte[] capaBytes5 = new byte[]{64, 2, 0, 0};
        ByteBuf b = Unpooled.buffer((int)capaBytes5.length);
        handler.serializeCapability(new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(new GracefulRestartCapabilityBuilder().build()).build()).build(), b);
        Assert.assertArrayEquals((byte[])capaBytes5, (byte[])b.array());
        Assert.assertEquals((Object)new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(new GracefulRestartCapabilityBuilder().setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.FALSE)).setRestartTime(Integer.valueOf(0)).setTables(Collections.emptyList()).build()).build()).build(), (Object)handler.parseCapability(Unpooled.wrappedBuffer((byte[])capaBytes5).slice(2, capaBytes5.length - 2)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledAfi() {
        GracefulCapabilityHandler handler = new GracefulCapabilityHandler(this.ctx.getAddressFamilyRegistry(), this.ctx.getSubsequentAddressFamilyRegistry());
        GracefulRestartCapabilityBuilder capaBuilder = new GracefulRestartCapabilityBuilder();
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.valueOf(true)));
        capaBuilder.setRestartTime(Integer.valueOf(50));
        TablesBuilder tablesBuilder = new TablesBuilder();
        tablesBuilder.setAfiFlags(new Tables.AfiFlags(Boolean.valueOf(true)));
        tablesBuilder.setAfi(AddressFamily.class);
        tablesBuilder.setSafi(UnicastSubsequentAddressFamily.class);
        capaBuilder.setTables((List)Lists.newArrayList((Object[])new Tables[]{tablesBuilder.build()}));
        ByteBuf buffer = Unpooled.buffer();
        handler.serializeCapability(new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledSafi() {
        GracefulCapabilityHandler handler = new GracefulCapabilityHandler(this.ctx.getAddressFamilyRegistry(), this.ctx.getSubsequentAddressFamilyRegistry());
        GracefulRestartCapabilityBuilder capaBuilder = new GracefulRestartCapabilityBuilder();
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.valueOf(true)));
        capaBuilder.setRestartTime(Integer.valueOf(50));
        TablesBuilder tablesBuilder = new TablesBuilder();
        tablesBuilder.setAfiFlags(new Tables.AfiFlags(Boolean.valueOf(true)));
        tablesBuilder.setAfi(Ipv4AddressFamily.class);
        tablesBuilder.setSafi(SubsequentAddressFamily.class);
        capaBuilder.setTables((List)Lists.newArrayList((Object[])new Tables[]{tablesBuilder.build()}));
        ByteBuf buffer = Unpooled.buffer();
        handler.serializeCapability(new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRestartTimeMinValue() {
        GracefulCapabilityHandler handler = new GracefulCapabilityHandler(this.ctx.getAddressFamilyRegistry(), this.ctx.getSubsequentAddressFamilyRegistry());
        GracefulRestartCapabilityBuilder capaBuilder = new GracefulRestartCapabilityBuilder();
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.valueOf(true)));
        capaBuilder.setRestartTime(Integer.valueOf(-1));
        TablesBuilder tablesBuilder = new TablesBuilder();
        tablesBuilder.setAfiFlags(new Tables.AfiFlags(Boolean.valueOf(true)));
        tablesBuilder.setAfi(Ipv4AddressFamily.class);
        tablesBuilder.setSafi(UnicastSubsequentAddressFamily.class);
        capaBuilder.setTables((List)Lists.newArrayList((Object[])new Tables[]{tablesBuilder.build()}));
        ByteBuf buffer = Unpooled.buffer();
        handler.serializeCapability(new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRestartTimeMaxValue() {
        GracefulCapabilityHandler handler = new GracefulCapabilityHandler(this.ctx.getAddressFamilyRegistry(), this.ctx.getSubsequentAddressFamilyRegistry());
        GracefulRestartCapabilityBuilder capaBuilder = new GracefulRestartCapabilityBuilder();
        capaBuilder.setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.valueOf(true)));
        capaBuilder.setRestartTime(Integer.valueOf(50000));
        TablesBuilder tablesBuilder = new TablesBuilder();
        tablesBuilder.setAfiFlags(new Tables.AfiFlags(Boolean.valueOf(true)));
        tablesBuilder.setAfi(Ipv4AddressFamily.class);
        tablesBuilder.setSafi(UnicastSubsequentAddressFamily.class);
        capaBuilder.setTables((List)Lists.newArrayList((Object[])new Tables[]{tablesBuilder.build()}));
        ByteBuf buffer = Unpooled.buffer();
        handler.serializeCapability(new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(capaBuilder.build()).build()).build(), buffer);
    }
}

