/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.Ipv4NlriParser;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.ipv4.prefixes.DestinationIpv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.ipv4.prefixes.destination.ipv4.Ipv4Prefixes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.ipv4.prefixes.destination.ipv4.Ipv4PrefixesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.update.attributes.mp.reach.nlri.advertized.routes.destination.type.DestinationIpv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.update.attributes.mp.unreach.nlri.withdrawn.routes.destination.type.DestinationIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.message.NlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.attributes.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.attributes.MpUnreachNlriBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv4NlriParserTest {
    private final Ipv4NlriParser parser = new Ipv4NlriParser();
    private final String ipPrefix1 = "1.2.3.4/32";
    private final String ipPrefix2 = "1.2.3.5/32";
    private final String additionalIpWD = "1.2.3.6/32";
    private final List<Ipv4Prefixes> prefixes = new ArrayList<Ipv4Prefixes>();
    private final ByteBuf inputBytes = Unpooled.buffer();
    private org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.update.attributes.mp.unreach.nlri.withdrawn.routes.destination.type.DestinationIpv4Case ip4caseWD;
    private org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.update.attributes.mp.unreach.nlri.withdrawn.routes.destination.type.DestinationIpv4Case ip4caseWDWrong;
    private DestinationIpv4Case ip4caseAD;
    private DestinationIpv4Case ip4caseADWrong;
    private Nlri nlri;
    private Nlri nlriWrong;

    @Before
    public void setUp() {
        Ipv4Prefix prefix1 = new Ipv4Prefix(this.ipPrefix1);
        Ipv4Prefix prefix2 = new Ipv4Prefix(this.ipPrefix2);
        Ipv4Prefix wrongPrefix = new Ipv4Prefix(this.additionalIpWD);
        this.prefixes.add(new Ipv4PrefixesBuilder().setPrefix(prefix1).build());
        this.prefixes.add(new Ipv4PrefixesBuilder().setPrefix(prefix2).build());
        this.ip4caseWD = new DestinationIpv4CaseBuilder().setDestinationIpv4(new DestinationIpv4Builder().setIpv4Prefixes(this.prefixes).build()).build();
        this.ip4caseAD = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.update.attributes.mp.reach.nlri.advertized.routes.destination.type.DestinationIpv4CaseBuilder().setDestinationIpv4(new DestinationIpv4Builder().setIpv4Prefixes(this.prefixes).build()).build();
        ArrayList<Ipv4Prefixes> fakePrefixes = new ArrayList<Ipv4Prefixes>(this.prefixes);
        fakePrefixes.add(new Ipv4PrefixesBuilder().setPrefix(wrongPrefix).build());
        this.ip4caseWDWrong = new DestinationIpv4CaseBuilder().setDestinationIpv4(new DestinationIpv4Builder().setIpv4Prefixes(fakePrefixes).build()).build();
        this.ip4caseADWrong = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.inet.rev150305.update.attributes.mp.reach.nlri.advertized.routes.destination.type.DestinationIpv4CaseBuilder().setDestinationIpv4(new DestinationIpv4Builder().setIpv4Prefixes(fakePrefixes).build()).build();
        this.inputBytes.writeBytes(Ipv4Util.bytesForPrefixBegin((Ipv4Prefix)prefix1));
        this.inputBytes.writeBytes(Ipv4Util.bytesForPrefixBegin((Ipv4Prefix)prefix2));
        ArrayList<Ipv4Prefix> prefixList = new ArrayList<Ipv4Prefix>();
        prefixList.add(prefix1);
        prefixList.add(prefix2);
        this.nlri = new NlriBuilder().setNlri(prefixList).build();
        ArrayList prefixWrongList = Lists.newArrayList(prefixList.iterator());
        prefixWrongList.add(wrongPrefix);
        this.nlriWrong = new NlriBuilder().setNlri((List)prefixWrongList).build();
    }

    @Test
    public void prefixesTest() {
        Assert.assertEquals((Object)this.ipPrefix1, (Object)this.prefixes.get(0).getPrefix().getValue());
        Assert.assertEquals((Object)this.ipPrefix2, (Object)this.prefixes.get(1).getPrefix().getValue());
        Assert.assertEquals((long)2L, (long)this.prefixes.size());
    }

    @Test
    public void serializeAttributeTest() throws UnsupportedEncodingException {
        ByteBuf outputBytes = Unpooled.buffer();
        this.parser.serializeAttribute((DataObject)this.nlri, outputBytes);
        Assert.assertArrayEquals((byte[])this.inputBytes.array(), (byte[])outputBytes.array());
        this.parser.serializeAttribute((DataObject)this.nlriWrong, outputBytes);
        Assert.assertFalse((boolean)Arrays.equals(this.inputBytes.array(), outputBytes.array()));
    }

    @Test
    public void parseUnreachedNlriTest() {
        MpUnreachNlriBuilder b = new MpUnreachNlriBuilder();
        this.parser.parseNlri(this.inputBytes, b);
        Assert.assertNotNull((String)"Withdrawn routes, destination type should not be null", (Object)b.getWithdrawnRoutes().getDestinationType());
        Assert.assertEquals((long)this.ip4caseWD.hashCode(), (long)b.getWithdrawnRoutes().getDestinationType().hashCode());
        Assert.assertFalse((this.ip4caseWDWrong.hashCode() == b.getWithdrawnRoutes().getDestinationType().hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.ip4caseWD.toString().equals(b.getWithdrawnRoutes().getDestinationType().toString()));
        Assert.assertFalse((boolean)this.ip4caseWDWrong.toString().equals(b.getWithdrawnRoutes().getDestinationType().toString()));
    }

    @Test
    public void parseReachedNlriTest() throws BGPParsingException {
        MpReachNlriBuilder b = new MpReachNlriBuilder();
        this.parser.parseNlri(this.inputBytes, b);
        Assert.assertNotNull((String)"Advertized routes, destination type should not be null", (Object)b.getAdvertizedRoutes().getDestinationType());
        Assert.assertEquals((long)this.ip4caseAD.hashCode(), (long)b.getAdvertizedRoutes().getDestinationType().hashCode());
        Assert.assertFalse((this.ip4caseADWrong.hashCode() == b.getAdvertizedRoutes().getDestinationType().hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.ip4caseAD.toString().equals(b.getAdvertizedRoutes().getDestinationType().toString()));
        Assert.assertFalse((boolean)this.ip4caseADWrong.toString().equals(b.getAdvertizedRoutes().getDestinationType().toString()));
    }
}

