/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.open.MultiProtocolCapabilityHandler;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.MultiprotocolCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.UnicastSubsequentAddressFamily;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MultiProtocolCapabilityHandlerTest {
    private static final Class afi = Ipv6AddressFamily.class;
    @Mock
    private AddressFamilyRegistry afir;
    @Mock
    private AddressFamilyRegistry afirExpection;
    private static final Class safi = UnicastSubsequentAddressFamily.class;
    @Mock
    private SubsequentAddressFamilyRegistry safir;
    @Mock
    private SubsequentAddressFamilyRegistry safirException;
    private final ByteBuf serializedBytes = Unpooled.copiedBuffer((byte[])new byte[]{1, 4, 1, 4, 0, 4});

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ((AddressFamilyRegistry)Mockito.doReturn((Object)260).when((Object)this.afir)).numberForClass(afi);
        ((AddressFamilyRegistry)Mockito.doReturn((Object)afi).when((Object)this.afir)).classForFamily(260);
        ((AddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.afirExpection)).numberForClass(afi);
        ((AddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.afirExpection)).classForFamily(260);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn((Object)4).when((Object)this.safir)).numberForClass(safi);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn((Object)safi).when((Object)this.safir)).classForFamily(4);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.safirException)).numberForClass(safi);
        ((SubsequentAddressFamilyRegistry)Mockito.doReturn(null).when((Object)this.safirException)).classForFamily(4);
    }

    @Test
    public void testCapabilityHandler() throws BGPDocumentedException, BGPParsingException {
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder().setAfi(afi).setSafi(safi).build()).build()).build();
        ByteBuf bytes = Unpooled.buffer();
        MultiProtocolCapabilityHandler handler = new MultiProtocolCapabilityHandler(this.afir, this.safir);
        handler.serializeCapability(capabilityToSerialize, bytes);
        CParameters newCaps = handler.parseCapability(bytes);
        Assert.assertEquals((long)capabilityToSerialize.hashCode(), (long)newCaps.hashCode());
    }

    @Test(expected=BGPParsingException.class)
    public void testAfiException() throws BGPDocumentedException, BGPParsingException {
        ByteBuf bytes = this.serializedBytes.copy();
        MultiProtocolCapabilityHandler handler = new MultiProtocolCapabilityHandler(this.afirExpection, this.safir);
        handler.parseCapability(bytes);
    }

    @Test(expected=BGPParsingException.class)
    public void testSafiException() throws BGPDocumentedException, BGPParsingException {
        ByteBuf bytes = this.serializedBytes.copy();
        MultiProtocolCapabilityHandler handler = new MultiProtocolCapabilityHandler(this.afir, this.safirException);
        handler.parseCapability(bytes);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledAfi() {
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder().setAfi(afi).setSafi(safi).build()).build()).build();
        ByteBuf bytes = Unpooled.buffer();
        MultiProtocolCapabilityHandler handler = new MultiProtocolCapabilityHandler(this.afirExpection, this.safir);
        handler.serializeCapability(capabilityToSerialize, bytes);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnhandledSafi() {
        CParameters capabilityToSerialize = new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder().setAfi(afi).setSafi(safi).build()).build()).build();
        ByteBuf bytes = Unpooled.buffer();
        MultiProtocolCapabilityHandler handler = new MultiProtocolCapabilityHandler(this.afir, this.safirException);
        handler.serializeCapability(capabilityToSerialize, bytes);
    }

    @Test
    public void noSerializationTest() {
        CParameters capabilityNoAugmentation = new CParametersBuilder().addAugmentation(CParameters1.class, null).build();
        CParameters capabilityNoMP = new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().build()).build();
        ByteBuf bytes = Unpooled.buffer();
        MultiProtocolCapabilityHandler handler = new MultiProtocolCapabilityHandler(this.afir, this.safirException);
        handler.serializeCapability(capabilityNoAugmentation, bytes);
        Assert.assertEquals((long)0L, (long)bytes.readableBytes());
        handler.serializeCapability(capabilityNoMP, bytes);
        Assert.assertEquals((long)0L, (long)bytes.readableBytes());
    }
}

