/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.BGPOpenMessageParser;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.BgpParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.OptionalCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.OptionalCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapabilityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.GracefulRestartCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.open.bgp.parameters.optional.capabilities.c.parameters.GracefulRestartCapabilityBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.Notification;

public class OpenTest {
    @Test
    public void testSerializeOpen() throws Exception {
        ArrayList optionalCapas = Lists.newArrayList();
        OptionalCapabilities optionalCapabilitiesBuilder = new OptionalCapabilitiesBuilder().setCParameters(new CParametersBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Long.valueOf(1000L))).build()).addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setGracefulRestartCapability(new GracefulRestartCapabilityBuilder().setRestartFlags(new GracefulRestartCapability.RestartFlags(Boolean.valueOf(false))).setRestartTime(Integer.valueOf(0)).setTables(Collections.EMPTY_LIST).build()).build()).build()).build();
        optionalCapas.add(optionalCapabilitiesBuilder);
        ArrayList tlvs = Lists.newArrayList((Object[])new BgpParameters[]{new BgpParametersBuilder().setOptionalCapabilities((List)optionalCapas).build()});
        Open open = new OpenBuilder().setBgpIdentifier(new Ipv4Address("127.0.0.1")).setMyAsNumber(Integer.valueOf(30)).setHoldTimer(Integer.valueOf(3)).setVersion(new ProtocolVersion(Short.valueOf((short)4))).setBgpParameters((List)tlvs).build();
        ByteBuf msg = Unpooled.buffer();
        new BGPOpenMessageParser(ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getParameterRegistry()).serializeMessage((Notification)open, msg);
        byte[] temp = ByteArray.cutBytes((byte[])ByteArray.getAllBytes((ByteBuf)msg), (int)19);
        Open openResult = new BGPOpenMessageParser(ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getParameterRegistry()).parseMessageBody(Unpooled.copiedBuffer((byte[])temp), temp.length);
        Assert.assertEquals((Object)open.getBgpIdentifier(), (Object)openResult.getBgpIdentifier());
        Assert.assertEquals((Object)open.getHoldTimer(), (Object)openResult.getHoldTimer());
        Assert.assertEquals((Object)open.getMyAsNumber(), (Object)openResult.getMyAsNumber());
        boolean grace = false;
        if (((OptionalCapabilities)((BgpParameters)openResult.getBgpParameters().get(0)).getOptionalCapabilities().get(0)).getCParameters().getAs4BytesCapability() != null) {
            grace = true;
        }
        Assert.assertEquals((Object)((OptionalCapabilities)((BgpParameters)open.getBgpParameters().get(0)).getOptionalCapabilities().get(0)).getCParameters().getAs4BytesCapability(), (Object)((OptionalCapabilities)((BgpParameters)openResult.getBgpParameters().get(0)).getOptionalCapabilities().get(!grace ? 1 : 0)).getCParameters().getAs4BytesCapability());
        Assert.assertEquals((Object)((CParameters1)((OptionalCapabilities)((BgpParameters)open.getBgpParameters().get(0)).getOptionalCapabilities().get(0)).getCParameters().getAugmentation(CParameters1.class)).getGracefulRestartCapability(), (Object)((CParameters1)((OptionalCapabilities)((BgpParameters)openResult.getBgpParameters().get(0)).getOptionalCapabilities().get(grace ? 1 : 0)).getCParameters().getAugmentation(CParameters1.class)).getGracefulRestartCapability());
    }
}

