/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AigpAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.Aigp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.aigp.AigpTlv;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathAttributeParserTest {
    @Test
    public void testOriginParser() {
        try {
            ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getAttributeRegistry().parseAttributes(Unpooled.copiedBuffer((byte[])new byte[]{64, 1, 1, 4}));
            Assert.fail((String)"This needs to fail.");
        }
        catch (BGPDocumentedException e) {
            Assert.assertEquals((Object)"Unknown Origin type.", (Object)e.getMessage());
            Assert.assertArrayEquals((byte[])new byte[]{1, 1, 4}, (byte[])e.getData());
        }
        catch (BGPParsingException e) {
            Assert.fail((String)"This exception should not occur.");
        }
    }

    @Test
    public void testParsingAigpAttributeWithCorrectTLV() throws BGPDocumentedException, BGPParsingException {
        byte[] value = new byte[]{1, 0, 11, 0, 0, 0, 0, 0, 0, 0, 8};
        ByteBuf buffer = Unpooled.buffer();
        AttributeUtil.formatAttribute((int)128, (int)26, (ByteBuf)Unpooled.copiedBuffer((byte[])value), (ByteBuf)buffer);
        BGPExtensionProviderContext providerContext = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance();
        Attributes pathAttributes = providerContext.getAttributeRegistry().parseAttributes(buffer);
        Aigp aigp = pathAttributes.getAigp();
        AigpTlv tlv = aigp.getAigpTlv();
        Assert.assertNotNull((String)"Tlv should not be null.", (Object)tlv);
        Assert.assertEquals((String)"Aigp tlv should have metric with value 8.", (long)8L, (long)tlv.getMetric().getValue().intValue());
    }

    @Test
    public void testSerializingAigpAttribute() throws BGPDocumentedException, BGPParsingException {
        byte[] value = new byte[]{1, 0, 11, 0, 0, 0, 0, 0, 0, 0, 8};
        ByteBuf inputData = Unpooled.buffer();
        ByteBuf testBuffer = Unpooled.buffer();
        AttributeUtil.formatAttribute((int)128, (int)26, (ByteBuf)Unpooled.copiedBuffer((byte[])value), (ByteBuf)inputData);
        BGPExtensionProviderContext providerContext = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance();
        Attributes pathAttributes = providerContext.getAttributeRegistry().parseAttributes(inputData);
        Aigp aigp = pathAttributes.getAigp();
        AttributesBuilder pathAttributesBuilder = new AttributesBuilder();
        pathAttributesBuilder.setAigp(aigp);
        AigpAttributeParser parser = new AigpAttributeParser();
        parser.serializeAttribute((DataObject)pathAttributesBuilder.build(), testBuffer);
        byte[] unparserData = inputData.copy(0, inputData.writerIndex()).array();
        byte[] serializedData = testBuffer.copy(0, inputData.writerIndex()).array();
        Assert.assertTrue((String)"Buffers should be the same.", (boolean)Arrays.equals(unparserData, serializedData));
    }
}

