/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.update.ClusterIdAttributeParser;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ClusterIdentifier;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ClusterIdAttributeParserTest
extends TestCase {
    private static final byte[] clusterIdBytes = new byte[]{-128, 10, 8, -64, -88, 1, 1, -64, -88, 1, 2};
    ClusterIdAttributeParser parser;

    @Before
    public void setUp() {
        this.parser = new ClusterIdAttributeParser();
    }

    @Test
    public void testParserAttribute() throws Exception {
        ArrayList list = Lists.newArrayList();
        Ipv4Address ip1 = new Ipv4Address("192.168.1.1");
        Ipv4Address ip2 = new Ipv4Address("192.168.1.2");
        list.add(new ClusterIdentifier(ip1));
        list.add(new ClusterIdentifier(ip2));
        Attributes clusterId = new AttributesBuilder().setClusterId(new ClusterIdBuilder().setCluster((List)list).build()).build();
        ByteBuf output = Unpooled.buffer();
        this.parser.serializeAttribute((DataObject)clusterId, output);
        Assert.assertArrayEquals((byte[])clusterIdBytes, (byte[])ByteArray.getAllBytes((ByteBuf)output));
        AttributesBuilder clusterIdOutput = new AttributesBuilder();
        this.parser.parseAttribute(Unpooled.wrappedBuffer((byte[])ByteArray.cutBytes((byte[])clusterIdBytes, (int)3)), clusterIdOutput);
        ClusterIdAttributeParserTest.assertEquals((Object)clusterId, (Object)clusterIdOutput.build());
    }

    @Test
    public void testParseEmptyListAttribute() {
        ArrayList list = Lists.newArrayList();
        Attributes clusterId = new AttributesBuilder().setClusterId(new ClusterIdBuilder().setCluster((List)list).build()).build();
        ByteBuf output = Unpooled.buffer();
        this.parser.serializeAttribute((DataObject)clusterId, output);
        ClusterIdAttributeParserTest.assertEquals((Object)Unpooled.buffer(), (Object)output);
    }

    @Test
    public void testParseEmptyAttribute() {
        Attributes clusterId = new AttributesBuilder().setClusterId(new ClusterIdBuilder().build()).build();
        ByteBuf output = Unpooled.buffer();
        this.parser.serializeAttribute((DataObject)clusterId, output);
        ClusterIdAttributeParserTest.assertEquals((Object)Unpooled.buffer(), (Object)output);
    }
}

