/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunityUtil;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.NoopReferenceCache;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.Communities;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CommunitiesAttributeParserTest
extends TestCase {
    private static final byte[] CommunitiesBytes = new byte[]{-64, 8, 16, -1, -1, -1, 1, -1, -1, -1, 2, -1, -1, -1, 3, -1, -1, -1, 16};

    @Test
    public void testCommunitiesAttributeParser() throws Exception {
        ArrayList comms = Lists.newArrayList();
        comms.add((Communities)CommunityUtil.NO_EXPORT);
        comms.add((Communities)CommunityUtil.NO_ADVERTISE);
        comms.add((Communities)CommunityUtil.NO_EXPORT_SUBCONFED);
        comms.add((Communities)CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), (long)65535L, (int)65296));
        AttributesBuilder paBuilder = new AttributesBuilder();
        paBuilder.setCommunities((List)comms);
        ByteBuf actual = Unpooled.buffer();
        ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getAttributeRegistry().serializeAttribute((DataObject)paBuilder.build(), actual);
        Assert.assertArrayEquals((byte[])CommunitiesBytes, (byte[])ByteArray.getAllBytes((ByteBuf)actual));
        Attributes attributeOut = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getAttributeRegistry().parseAttributes(actual);
        CommunitiesAttributeParserTest.assertEquals((Object)comms, (Object)attributeOut.getCommunities());
    }

    @Test
    public void testParseEmptyListAttribute() {
        ArrayList comms = Lists.newArrayList();
        ByteBuf actual = Unpooled.buffer();
        ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getAttributeRegistry().serializeAttribute((DataObject)new AttributesBuilder().setCommunities((List)comms).build(), actual);
        CommunitiesAttributeParserTest.assertEquals((Object)Unpooled.buffer(), (Object)actual);
    }

    @Test
    public void testParseEmptyAttribute() {
        ByteBuf actual = Unpooled.buffer();
        ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getAttributeRegistry().serializeAttribute((DataObject)new AttributesBuilder().build(), actual);
        CommunitiesAttributeParserTest.assertEquals((Object)Unpooled.buffer(), (Object)actual);
    }
}

