/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.primitives.Bytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.ExtendedCommunitiesAttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityRegistry;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.ExtendedCommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteOriginExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteOriginExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.origin.extended.community._case.RouteOriginExtendedCommunityBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ExtendedCommunitiesAttributeParserTest {
    private static final byte[] INPUT = new byte[]{64, 3, 0, 54, 0, 0, 1, 76};
    private static final byte[] UNKOWN = new byte[]{64, 5, 0, 54, 0, 0, 1, 76};
    private ExtendedCommunitiesAttributeParser handler;

    @Before
    public void setUp() {
        ExtendedCommunityRegistry exReg = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance().getExtendedCommunityReistry();
        this.handler = new ExtendedCommunitiesAttributeParser(exReg);
    }

    @Test
    public void testExtendedCommunityAttributeParser() throws BGPDocumentedException, BGPParsingException {
        RouteOriginExtendedCommunityCase routeOrigin = new RouteOriginExtendedCommunityCaseBuilder().setRouteOriginExtendedCommunity(new RouteOriginExtendedCommunityBuilder().setGlobalAdministrator(new ShortAsNumber(Long.valueOf(54L))).setLocalAdministrator(new byte[]{0, 0, 1, 76}).build()).build();
        ExtendedCommunities expected = new ExtendedCommunitiesBuilder().setTransitive(Boolean.valueOf(false)).setExtendedCommunity((ExtendedCommunity)routeOrigin).build();
        AttributesBuilder attBuilder = new AttributesBuilder();
        this.handler.parseAttribute(Unpooled.copiedBuffer((byte[])INPUT), attBuilder);
        ExtendedCommunities parsed = (ExtendedCommunities)attBuilder.getExtendedCommunities().get(0);
        Assert.assertEquals((Object)expected, (Object)parsed);
        ByteBuf output = Unpooled.buffer((int)INPUT.length);
        this.handler.serializeAttribute((DataObject)attBuilder.build(), output);
        Assert.assertArrayEquals((byte[])Bytes.concat((byte[][])new byte[][]{{-64, 16, 8}, INPUT}), (byte[])ByteArray.readAllBytes((ByteBuf)output));
    }

    @Test
    public void testEmptyListExtendedCommunityAttributeParser() throws BGPDocumentedException, BGPParsingException {
        ArrayList extendedCommunitiesList = new ArrayList();
        AttributesBuilder attBuilder = new AttributesBuilder().setExtendedCommunities(extendedCommunitiesList);
        ByteBuf output = Unpooled.buffer();
        this.handler.serializeAttribute((DataObject)attBuilder.build(), output);
        Assert.assertEquals((Object)output, (Object)output);
    }

    @Test
    public void testEmptyExtendedCommunityAttributeParser() throws BGPDocumentedException, BGPParsingException {
        ByteBuf output = Unpooled.buffer();
        this.handler.serializeAttribute((DataObject)new AttributesBuilder().build(), output);
        Assert.assertEquals((Object)Unpooled.buffer(), (Object)output);
    }

    @Test
    public void testExtendedCommunityAttributeParserUnknown() throws BGPDocumentedException, BGPParsingException {
        AttributesBuilder attBuilder = new AttributesBuilder();
        this.handler.parseAttribute(Unpooled.copiedBuffer((byte[])UNKOWN), attBuilder);
        Assert.assertTrue((boolean)attBuilder.getExtendedCommunities().isEmpty());
    }
}

