/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.Ipv4SpecificEcHandler;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.Inet4SpecificExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.Inet4SpecificExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.inet4.specific.extended.community._case.Inet4SpecificExtendedCommunityBuilder;

public class Ipv4SpecificEcHandlerTest {
    private static final byte[] INPUT = new byte[]{12, 51, 2, 5, 21, 45};

    @Test
    public void testHandler() throws BGPDocumentedException, BGPParsingException {
        Ipv4SpecificEcHandler handler = new Ipv4SpecificEcHandler();
        Inet4SpecificExtendedCommunityCase expected = new Inet4SpecificExtendedCommunityCaseBuilder().setInet4SpecificExtendedCommunity(new Inet4SpecificExtendedCommunityBuilder().setTransitive(Boolean.valueOf(true)).setGlobalAdministrator(new Ipv4Address("12.51.2.5")).setLocalAdministrator(new byte[]{21, 45}).build()).build();
        ExtendedCommunity exComm = handler.parseExtendedCommunity(Unpooled.copiedBuffer((byte[])INPUT));
        Assert.assertEquals((Object)expected, (Object)exComm);
        ByteBuf output = Unpooled.buffer((int)INPUT.length);
        handler.serializeExtendedCommunity((ExtendedCommunity)expected, output);
        Assert.assertArrayEquals((byte[])INPUT, (byte[])output.array());
    }
}

