/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities.RouteTargetAsTwoOctetEcHandler;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteTargetExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteTargetExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.target.extended.community._case.RouteTargetExtendedCommunityBuilder;

public class RouteTargetAsTwoOctetEcHandlerTest {
    private static final byte[] INPUT = new byte[]{0, 35, 4, 2, 8, 7};

    @Test
    public void testHandler() throws BGPDocumentedException, BGPParsingException {
        RouteTargetAsTwoOctetEcHandler handler = new RouteTargetAsTwoOctetEcHandler();
        RouteTargetExtendedCommunityCase expected = new RouteTargetExtendedCommunityCaseBuilder().setRouteTargetExtendedCommunity(new RouteTargetExtendedCommunityBuilder().setGlobalAdministrator(new ShortAsNumber(Long.valueOf(35L))).setLocalAdministrator(new byte[]{4, 2, 8, 7}).build()).build();
        ExtendedCommunity exComm = handler.parseExtendedCommunity(Unpooled.copiedBuffer((byte[])INPUT));
        Assert.assertEquals((Object)expected, (Object)exComm);
        ByteBuf output = Unpooled.buffer((int)INPUT.length);
        handler.serializeExtendedCommunity((ExtendedCommunity)expected, output);
        Assert.assertArrayEquals((byte[])INPUT, (byte[])output.array());
    }
}

