/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.next.hop;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.next.hop.Ipv4NextHopParserSerializer;
import org.opendaylight.protocol.bgp.parser.impl.message.update.next.hop.Ipv6NextHopParserSerializer;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv4NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv6NextHopCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.Ipv6NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.c.next.hop.ipv6.next.hop._case.Ipv6NextHopBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class NextHopParserSerializerTest {
    public static final byte[] ipv6lB = new byte[]{32, 1, 13, -72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -2, -128, 0, 0, 0, 0, 0, 0, -64, 1, 11, -1, -2, 126, 0, 0};
    public static final Ipv6Address ipv6 = new Ipv6Address("2001:db8::1");
    public static final Ipv6Address ipv6l = new Ipv6Address("fe80::c001:bff:fe7e:0");
    Ipv4NextHopParserSerializer ipv4NextHopParserSerializer;
    Ipv6NextHopParserSerializer ipv6NextHopParserSerializer;
    CNextHop hop;
    ByteBuf buffer;

    @Before
    public final void setUp() {
        this.ipv4NextHopParserSerializer = new Ipv4NextHopParserSerializer();
        this.ipv6NextHopParserSerializer = new Ipv6NextHopParserSerializer();
        this.buffer = Unpooled.buffer();
    }

    @Test
    public void testSerializeIpv4NextHopCase() throws BGPParsingException {
        byte[] ipv4B = new byte[]{42, 42, 42, 42};
        this.hop = new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("42.42.42.42")).build()).build();
        this.ipv4NextHopParserSerializer.serializeNextHop(this.hop, this.buffer);
        Assert.assertArrayEquals((byte[])ipv4B, (byte[])ByteArray.readAllBytes((ByteBuf)this.buffer));
        CNextHop parsedHop = this.ipv4NextHopParserSerializer.parseNextHop(Unpooled.wrappedBuffer((byte[])ipv4B));
        Assert.assertTrue((boolean)(this.hop instanceof Ipv4NextHopCase));
        Assert.assertEquals((Object)this.hop, (Object)parsedHop);
    }

    @Test
    public void testSerializeIpv6LinkNextHopCase() throws BGPParsingException {
        this.hop = new Ipv6NextHopCaseBuilder().setIpv6NextHop(new Ipv6NextHopBuilder().setGlobal(ipv6).setLinkLocal(ipv6l).build()).build();
        this.buffer.clear();
        this.ipv6NextHopParserSerializer.serializeNextHop(this.hop, this.buffer);
        Assert.assertArrayEquals((byte[])ipv6lB, (byte[])ByteArray.readAllBytes((ByteBuf)this.buffer));
        CNextHop parsedHop = this.ipv6NextHopParserSerializer.parseNextHop(Unpooled.wrappedBuffer((byte[])ipv6lB));
        Assert.assertTrue((boolean)(parsedHop instanceof Ipv6NextHopCase));
        Assert.assertEquals((Object)this.hop, (Object)parsedHop);
    }

    @Test
    public void testSerializeIpv4NextHopEmpty() {
        this.buffer.clear();
        try {
            this.ipv4NextHopParserSerializer.serializeNextHop(new CNextHop(){

                public Class<? extends DataContainer> getImplementedInterface() {
                    return null;
                }
            }, this.buffer);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"cNextHop is not a Ipv4 NextHop object.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSerializeIpv6NextHopEmpty() {
        this.buffer.clear();
        try {
            this.ipv6NextHopParserSerializer.serializeNextHop(new CNextHop(){

                public Class<? extends DataContainer> getImplementedInterface() {
                    return null;
                }
            }, this.buffer);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"cNextHop is not a Ipv6 NextHop object.", (Object)e.getMessage());
        }
    }
}

