/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Keepalive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.KeepaliveBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;

public final class BGPKeepAliveMessageParser
implements MessageParser,
MessageSerializer {
    public static final int TYPE = 4;
    private static final Keepalive KEEPALIVE_MSG = new KeepaliveBuilder().build();
    private static final ByteBuf KEEPALIVE_BYTES = Unpooled.buffer();

    public Keepalive parseMessageBody(ByteBuf body, int messageLength) throws BGPDocumentedException {
        if (body.isReadable()) {
            throw BGPDocumentedException.badMessageLength((String)"Message length field not within valid range.", (int)messageLength);
        }
        return KEEPALIVE_MSG;
    }

    public void serializeMessage(Notification message, ByteBuf bytes) {
        Preconditions.checkArgument((boolean)(message instanceof Keepalive));
        bytes.writeBytes(KEEPALIVE_BYTES.slice());
    }

    static {
        MessageUtil.formatMessage((int)4, (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)KEEPALIVE_BYTES);
    }
}

