/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Notify;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.NotifyBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BGPNotificationMessageParser
implements MessageParser,
MessageSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(BGPNotificationMessageParser.class);
    public static final int TYPE = 3;
    private static final int ERROR_SIZE = 2;

    public void serializeMessage(Notification msg, ByteBuf bytes) {
        Preconditions.checkArgument((boolean)(msg instanceof Notify), (Object)"Message needs to be of type Notify");
        Notify ntf = (Notify)msg;
        ByteBuf msgBody = Unpooled.buffer();
        msgBody.writeByte((int)ntf.getErrorCode().shortValue());
        msgBody.writeByte((int)ntf.getErrorSubcode().shortValue());
        byte[] data = ntf.getData();
        if (data != null) {
            msgBody.writeBytes(data);
        }
        LOG.trace("Notification message serialized to: {}", (Object)ByteBufUtil.hexDump((ByteBuf)msgBody));
        MessageUtil.formatMessage((int)3, (ByteBuf)msgBody, (ByteBuf)bytes);
    }

    public Notify parseMessageBody(ByteBuf body, int messageLength) throws BGPDocumentedException {
        Preconditions.checkArgument((body != null ? 1 : 0) != 0, (Object)"Buffer cannot be null.");
        if (body.readableBytes() < 2) {
            throw BGPDocumentedException.badMessageLength((String)"Notification message too small.", (int)messageLength);
        }
        short errorCode = body.readUnsignedByte();
        short errorSubcode = body.readUnsignedByte();
        NotifyBuilder builder = new NotifyBuilder().setErrorCode(Short.valueOf(errorCode)).setErrorSubcode(Short.valueOf(errorSubcode));
        if (body.isReadable()) {
            builder.setData(ByteArray.readAllBytes((ByteBuf)body));
        }
        LOG.debug("BGP Notification message was parsed: err = {}, data = {}.", (Object)BGPError.forValue((int)errorCode, (int)errorSubcode), (Object)Arrays.toString(builder.getData()));
        return builder.build();
    }
}

