/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageUtil;
import org.opendaylight.protocol.bgp.parser.spi.ParameterRegistry;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.BgpParameters;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BGPOpenMessageParser
implements MessageParser,
MessageSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(BGPOpenMessageParser.class);
    public static final int TYPE = 1;
    private static final int VERSION_SIZE = 1;
    private static final int AS_SIZE = 2;
    private static final int HOLD_TIME_SIZE = 2;
    private static final int BGP_ID_SIZE = 4;
    private static final int OPT_PARAM_LENGTH_SIZE = 1;
    private static final int MIN_MSG_LENGTH = 10;
    private static final int BGP_VERSION = 4;
    public static final int AS_TRANS = 23456;
    private final ParameterRegistry reg;

    public BGPOpenMessageParser(ParameterRegistry reg) {
        this.reg = (ParameterRegistry)Preconditions.checkNotNull((Object)reg);
    }

    public void serializeMessage(Notification msg, ByteBuf bytes) {
        Preconditions.checkArgument((boolean)(msg instanceof Open), (Object)"Message needs to be of type Open");
        Open open = (Open)msg;
        ByteBuf msgBody = Unpooled.buffer();
        msgBody.writeByte(4);
        int openAS = open.getMyAsNumber();
        if (openAS > 65535) {
            openAS = 23456;
        }
        msgBody.writeShort(openAS);
        msgBody.writeShort(open.getHoldTimer().intValue());
        msgBody.writeBytes(Ipv4Util.bytesForAddress((Ipv4Address)open.getBgpIdentifier()));
        ByteBuf paramsBuffer = Unpooled.buffer();
        if (open.getBgpParameters() != null) {
            for (BgpParameters param : open.getBgpParameters()) {
                this.reg.serializeParameter(param, paramsBuffer);
            }
        }
        msgBody.writeByte(paramsBuffer.writerIndex());
        msgBody.writeBytes(paramsBuffer);
        MessageUtil.formatMessage((int)1, (ByteBuf)msgBody, (ByteBuf)bytes);
    }

    public Open parseMessageBody(ByteBuf body, int messageLength) throws BGPDocumentedException {
        Preconditions.checkArgument((body != null ? 1 : 0) != 0, (Object)"Buffer cannot be null.");
        if (body.readableBytes() < 10) {
            throw BGPDocumentedException.badMessageLength((String)"Open message too small.", (int)messageLength);
        }
        short version = body.readUnsignedByte();
        if (version != 4) {
            throw new BGPDocumentedException("BGP Protocol version " + version + " not supported.", BGPError.VERSION_NOT_SUPPORTED);
        }
        AsNumber as = new AsNumber(Long.valueOf(body.readUnsignedShort()));
        int holdTime = body.readUnsignedShort();
        if (holdTime == 1 || holdTime == 2) {
            throw new BGPDocumentedException("Hold time value not acceptable.", BGPError.HOLD_TIME_NOT_ACC);
        }
        Ipv4Address bgpId = null;
        try {
            bgpId = Ipv4Util.addressForByteBuf((ByteBuf)body);
        }
        catch (IllegalArgumentException e) {
            throw new BGPDocumentedException("BGP Identifier is not a valid IPv4 Address", BGPError.BAD_BGP_ID, (Exception)e);
        }
        short optLength = body.readUnsignedByte();
        ArrayList<BgpParameters> optParams = new ArrayList<BgpParameters>();
        if (optLength > 0) {
            this.fillParams(body.slice(), optParams);
        }
        LOG.debug("BGP Open message was parsed: AS = {}, holdTimer = {}, bgpId = {}, optParams = {}", new Object[]{as, holdTime, bgpId, optParams});
        return new OpenBuilder().setMyAsNumber(Integer.valueOf(as.getValue().intValue())).setHoldTimer(Integer.valueOf(holdTime)).setBgpIdentifier(bgpId).setBgpParameters(optParams).build();
    }

    private void fillParams(ByteBuf buffer, List<BgpParameters> params) throws BGPDocumentedException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"BUffer cannot be null or empty.");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Started parsing of BGP parameter: {}", (Object)ByteBufUtil.hexDump((ByteBuf)buffer));
        }
        while (buffer.isReadable()) {
            BgpParameters param;
            if (buffer.readableBytes() <= 2) {
                throw new BGPDocumentedException("Malformed parameter encountered (" + buffer.readableBytes() + " bytes left)", BGPError.OPT_PARAM_NOT_SUPPORTED);
            }
            short paramType = buffer.readUnsignedByte();
            short paramLength = buffer.readUnsignedByte();
            ByteBuf paramBody = buffer.readSlice((int)paramLength);
            try {
                param = this.reg.parseParameter((int)paramType, paramBody);
            }
            catch (BGPParsingException e) {
                throw new BGPDocumentedException("Optional parameter not parsed", BGPError.UNSPECIFIC_OPEN_ERROR, (Exception)((Object)e));
            }
            if (param != null) {
                params.add(param);
                continue;
            }
            LOG.debug("Ignoring BGP Parameter type: {}", (Object)paramType);
        }
        LOG.trace("Parsed BGP parameters: {}", params);
    }
}

