/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageUtil;
import org.opendaylight.protocol.bgp.parser.spi.MultiprotocolCapabilitiesUtil;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.RouteRefresh;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.RouteRefreshBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BGPRouteRefreshMessageParser
implements MessageParser,
MessageSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(BGPRouteRefreshMessageParser.class);
    public static final int TYPE = 5;
    private static final int TRIPLET_BYTE_SIZE = 4;
    private final AddressFamilyRegistry afiReg;
    private final SubsequentAddressFamilyRegistry safiReg;

    public BGPRouteRefreshMessageParser(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        this.afiReg = (AddressFamilyRegistry)Preconditions.checkNotNull((Object)afiReg);
        this.safiReg = (SubsequentAddressFamilyRegistry)Preconditions.checkNotNull((Object)safiReg);
    }

    public void serializeMessage(Notification message, ByteBuf bytes) {
        Preconditions.checkArgument((boolean)(message instanceof RouteRefresh), (Object)"Message is not of type RouteRefresh.");
        RouteRefresh msg = (RouteRefresh)message;
        ByteBuf msgBuf = Unpooled.buffer((int)4);
        MultiprotocolCapabilitiesUtil.serializeMPAfiSafi((AddressFamilyRegistry)this.afiReg, (SubsequentAddressFamilyRegistry)this.safiReg, (Class)msg.getAfi(), (Class)msg.getSafi(), (ByteBuf)msgBuf);
        LOG.trace("RouteRefresh message serialized to: {}", (Object)ByteBufUtil.hexDump((ByteBuf)msgBuf));
        MessageUtil.formatMessage((int)5, (ByteBuf)msgBuf, (ByteBuf)bytes);
    }

    public RouteRefresh parseMessageBody(ByteBuf body, int messageLength) throws BGPDocumentedException {
        Preconditions.checkArgument((body != null ? 1 : 0) != 0, (Object)"Body buffer cannot be null.");
        if (body.readableBytes() < 4) {
            throw BGPDocumentedException.badMessageLength((String)"RouteRefresh message is too small.", (int)messageLength);
        }
        Optional parsedAfiSafi = MultiprotocolCapabilitiesUtil.parseMPAfiSafi((ByteBuf)body, (AddressFamilyRegistry)this.afiReg, (SubsequentAddressFamilyRegistry)this.safiReg);
        if (!parsedAfiSafi.isPresent()) {
            throw new BGPDocumentedException("Unsupported afi/safi in Route Refresh message.", BGPError.WELL_KNOWN_ATTR_NOT_RECOGNIZED);
        }
        return new RouteRefreshBuilder((BgpTableType)parsedAfiSafi.get()).build();
    }
}

