/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.MessageUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.Update;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.UpdateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.message.Nlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.message.NlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.message.WithdrawnRoutes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.update.message.WithdrawnRoutesBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BGPUpdateMessageParser
implements MessageParser,
MessageSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(BGPUpdateMessageParser.class);
    public static final int TYPE = 2;
    private static final int WITHDRAWN_ROUTES_LENGTH_SIZE = 2;
    private static final int TOTAL_PATH_ATTR_LENGTH_SIZE = 2;
    private final AttributeRegistry reg;

    public BGPUpdateMessageParser(AttributeRegistry reg) {
        this.reg = (AttributeRegistry)Preconditions.checkNotNull((Object)reg);
    }

    public Update parseMessageBody(ByteBuf buffer, int messageLength) throws BGPDocumentedException {
        return this.parseMessageBody(buffer, messageLength, null);
    }

    public void serializeMessage(Notification message, ByteBuf bytes) {
        Preconditions.checkArgument((boolean)(message instanceof Update), (Object)"Message needs to be of type Update");
        Update update = (Update)message;
        ByteBuf messageBody = Unpooled.buffer();
        WithdrawnRoutes withdrawnRoutes = update.getWithdrawnRoutes();
        if (withdrawnRoutes != null) {
            ByteBuf withdrawnRoutesBuf = Unpooled.buffer();
            for (Ipv4Prefix prefix : withdrawnRoutes.getWithdrawnRoutes()) {
                ByteBufWriteUtil.writeMinimalPrefix((Ipv4Prefix)prefix, (ByteBuf)withdrawnRoutesBuf);
            }
            messageBody.writeShort(withdrawnRoutesBuf.writerIndex());
            messageBody.writeBytes(withdrawnRoutesBuf);
        } else {
            messageBody.writeZero(2);
        }
        if (update.getAttributes() != null) {
            ByteBuf pathAttributesBuf = Unpooled.buffer();
            this.reg.serializeAttribute((DataObject)update.getAttributes(), pathAttributesBuf);
            messageBody.writeShort(pathAttributesBuf.writerIndex());
            messageBody.writeBytes(pathAttributesBuf);
        } else {
            messageBody.writeZero(2);
        }
        Nlri nlri = update.getNlri();
        if (nlri != null && nlri.getNlri() != null) {
            for (Ipv4Prefix prefix : nlri.getNlri()) {
                ByteBufWriteUtil.writeMinimalPrefix((Ipv4Prefix)prefix, (ByteBuf)messageBody);
            }
        }
        MessageUtil.formatMessage((int)2, (ByteBuf)messageBody, (ByteBuf)bytes);
    }

    public Update parseMessageBody(ByteBuf buffer, int messageLength, PeerSpecificParserConstraint constraint) throws BGPDocumentedException {
        List nlri;
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Buffer cannot be null or empty.");
        UpdateBuilder builder = new UpdateBuilder();
        int withdrawnRoutesLength = buffer.readUnsignedShort();
        if (withdrawnRoutesLength > 0) {
            List withdrawnRoutes = Ipv4Util.prefixListForBytes((byte[])ByteArray.readBytes((ByteBuf)buffer, (int)withdrawnRoutesLength));
            builder.setWithdrawnRoutes(new WithdrawnRoutesBuilder().setWithdrawnRoutes(withdrawnRoutes).build());
        }
        int totalPathAttrLength = buffer.readUnsignedShort();
        if (withdrawnRoutesLength == 0 && totalPathAttrLength == 0) {
            return builder.build();
        }
        if (totalPathAttrLength > 0) {
            try {
                Attributes attributes = this.reg.parseAttributes(buffer.readSlice(totalPathAttrLength), constraint);
                builder.setAttributes(attributes);
            }
            catch (RuntimeException | BGPParsingException e) {
                throw new BGPDocumentedException("Could not parse BGP attributes.", BGPError.MALFORMED_ATTR_LIST, (Exception)e);
            }
        }
        if (!(nlri = Ipv4Util.prefixListForBytes((byte[])ByteArray.readAllBytes((ByteBuf)buffer))).isEmpty()) {
            builder.setNlri(new NlriBuilder().setNlri(nlri).build());
        }
        Update msg = builder.build();
        BGPUpdateMessageParser.checkMandatoryAttributesPresence(msg);
        LOG.debug("BGP Update message was parsed {}.", (Object)msg);
        return msg;
    }

    private static void checkMandatoryAttributesPresence(Update message) throws BGPDocumentedException {
        Preconditions.checkNotNull((Object)message, (Object)"Update message cannot be null");
        Attributes attrs = message.getAttributes();
        if (message.getNlri() != null && (attrs == null || attrs.getCNextHop() == null)) {
            throw new BGPDocumentedException("Well known mandatory attribute missing: NEXT_HOP", BGPError.WELL_KNOWN_ATTR_MISSING, new byte[]{3});
        }
        if (MessageUtil.isAnyNlriPresent((Update)message)) {
            if (attrs == null || attrs.getOrigin() == null) {
                throw new BGPDocumentedException("Well known mandatory attribute missing: ORIGIN", BGPError.WELL_KNOWN_ATTR_MISSING, new byte[]{1});
            }
            if (attrs == null || attrs.getAsPath() == null) {
                throw new BGPDocumentedException("Well known mandatory attribute missing: AS_PATH", BGPError.WELL_KNOWN_ATTR_MISSING, new byte[]{2});
            }
        }
    }
}

