/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.open;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.c.parameters.As4BytesCapabilityBuilder;

public final class As4CapabilityHandler
implements CapabilityParser,
CapabilitySerializer {
    public static final int CODE = 65;

    public CParameters parseCapability(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        return new CParametersBuilder().setAs4BytesCapability(new As4BytesCapabilityBuilder().setAsNumber(new AsNumber(Long.valueOf(buffer.readUnsignedInt()))).build()).build();
    }

    public void serializeCapability(CParameters capability, ByteBuf byteAggregator) {
        As4BytesCapability as4 = capability.getAs4BytesCapability();
        if (as4 != null) {
            CapabilityUtil.formatCapability((int)65, (ByteBuf)As4CapabilityHandler.putAS4BytesParameterValue(as4), (ByteBuf)byteAggregator);
        }
    }

    private static ByteBuf putAS4BytesParameterValue(As4BytesCapability param) {
        return Unpooled.copyInt((int)param.getAsNumber().getValue().intValue());
    }
}

