/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.open;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterParser;
import org.opendaylight.protocol.bgp.parser.spi.ParameterSerializer;
import org.opendaylight.protocol.bgp.parser.spi.ParameterUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.BgpParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.OptionalCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.OptionalCapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CapabilityParameterParser
implements ParameterParser,
ParameterSerializer {
    public static final int TYPE = 2;
    private static final Logger LOG = LoggerFactory.getLogger(CapabilityParameterParser.class);
    private final CapabilityRegistry reg;

    public CapabilityParameterParser(CapabilityRegistry reg) {
        this.reg = (CapabilityRegistry)Preconditions.checkNotNull((Object)reg);
    }

    public BgpParameters parseParameter(ByteBuf buffer) throws BGPParsingException, BGPDocumentedException {
        Preconditions.checkArgument((buffer != null && buffer.readableBytes() != 0 ? 1 : 0) != 0, (Object)"Byte array cannot be null or empty.");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Started parsing of BGP Capabilities: {}", (Object)Arrays.toString(ByteArray.getAllBytes((ByteBuf)buffer)));
        }
        ArrayList optionalCapas = Lists.newArrayList();
        while (buffer.isReadable()) {
            OptionalCapabilities optionalCapa = this.parseOptionalCapability(buffer);
            if (optionalCapa == null) continue;
            optionalCapas.add(optionalCapa);
        }
        return new BgpParametersBuilder().setOptionalCapabilities((List)optionalCapas).build();
    }

    private OptionalCapabilities parseOptionalCapability(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        short capLength;
        ByteBuf paramBody;
        short capCode = buffer.readUnsignedByte();
        CParameters ret = this.reg.parseCapability((int)capCode, paramBody = buffer.readSlice((int)(capLength = buffer.readUnsignedByte())));
        if (ret == null) {
            LOG.info("Ignoring unsupported capability {}", (Object)capCode);
            return null;
        }
        return new OptionalCapabilitiesBuilder().setCParameters(ret).build();
    }

    public void serializeParameter(BgpParameters parameter, ByteBuf byteAggregator) {
        if (parameter.getOptionalCapabilities() != null) {
            ByteBuf buffer = Unpooled.buffer();
            for (OptionalCapabilities optionalCapa : parameter.getOptionalCapabilities()) {
                LOG.trace("Started serializing BGP Capability: {}", (Object)optionalCapa);
                this.serializeOptionalCapability(optionalCapa, buffer);
            }
            ParameterUtil.formatParameter((int)2, (ByteBuf)buffer, (ByteBuf)byteAggregator);
        }
    }

    private void serializeOptionalCapability(OptionalCapabilities optionalCapa, ByteBuf byteAggregator) {
        if (optionalCapa.getCParameters() != null) {
            CParameters cap = optionalCapa.getCParameters();
            ByteBuf bytes = Unpooled.buffer();
            this.reg.serializeCapability(cap, bytes);
            Preconditions.checkArgument((bytes != null ? 1 : 0) != 0, (String)"Unhandled capability class %s", (Object)cap.getImplementedInterface());
            if (LOG.isTraceEnabled()) {
                LOG.trace("BGP capability serialized to: {}", (Object)ByteBufUtil.hexDump((ByteBuf)bytes));
            }
            byteAggregator.writeBytes(bytes);
        }
    }
}

