/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.open;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilitySerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityUtil;
import org.opendaylight.protocol.bgp.parser.spi.MultiprotocolCapabilitiesUtil;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.open.message.bgp.parameters.optional.capabilities.CParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.CParameters1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.CParameters1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.mp.capabilities.MultiprotocolCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.mp.capabilities.MultiprotocolCapabilityBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public final class MultiProtocolCapabilityHandler
implements CapabilityParser,
CapabilitySerializer {
    public static final int CODE = 1;
    private final AddressFamilyRegistry afiReg;
    private final SubsequentAddressFamilyRegistry safiReg;

    public MultiProtocolCapabilityHandler(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        this.afiReg = (AddressFamilyRegistry)Preconditions.checkNotNull((Object)afiReg);
        this.safiReg = (SubsequentAddressFamilyRegistry)Preconditions.checkNotNull((Object)safiReg);
    }

    public CParameters parseCapability(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        Optional parsedAfiSafiOptional = MultiprotocolCapabilitiesUtil.parseMPAfiSafi((ByteBuf)buffer, (AddressFamilyRegistry)this.afiReg, (SubsequentAddressFamilyRegistry)this.safiReg);
        if (!parsedAfiSafiOptional.isPresent()) {
            return null;
        }
        return new CParametersBuilder().addAugmentation(CParameters1.class, (Augmentation)new CParameters1Builder().setMultiprotocolCapability(new MultiprotocolCapabilityBuilder((BgpTableType)parsedAfiSafiOptional.get()).build()).build()).build();
    }

    public void serializeCapability(CParameters capability, ByteBuf byteAggregator) {
        if (capability.getAugmentation(CParameters1.class) == null || ((CParameters1)capability.getAugmentation(CParameters1.class)).getMultiprotocolCapability() == null) {
            return;
        }
        MultiprotocolCapability mp = ((CParameters1)capability.getAugmentation(CParameters1.class)).getMultiprotocolCapability();
        ByteBuf capBuffer = Unpooled.buffer();
        MultiprotocolCapabilitiesUtil.serializeMPAfiSafi((AddressFamilyRegistry)this.afiReg, (SubsequentAddressFamilyRegistry)this.safiReg, (Class)mp.getAfi(), (Class)mp.getSafi(), (ByteBuf)capBuffer);
        CapabilityUtil.formatCapability((int)1, (ByteBuf)capBuffer, (ByteBuf)byteAggregator);
    }
}

