/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.Aggregator;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.AggregatorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ShortAsNumber;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class AggregatorAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 7;
    private final ReferenceCache refCache;

    public AggregatorAttributeParser(ReferenceCache refCache) {
        this.refCache = (ReferenceCache)Preconditions.checkNotNull((Object)refCache);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) {
        AsNumber asNumber = (AsNumber)this.refCache.getSharedReference((Object)new AsNumber(Long.valueOf(buffer.readUnsignedInt())));
        Ipv4Address address = Ipv4Util.addressForByteBuf((ByteBuf)buffer);
        builder.setAggregator(new AggregatorBuilder().setAsNumber(asNumber).setNetworkAddress(address).build());
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        Attributes pathAttributes = (Attributes)attribute;
        Aggregator aggregator = pathAttributes.getAggregator();
        if (aggregator == null) {
            return;
        }
        Preconditions.checkArgument((aggregator.getAsNumber() != null ? 1 : 0) != 0, (Object)"Missing AS number that formed the aggregate route (encoded as 2 octets).");
        ShortAsNumber shortAsNumber = new ShortAsNumber(aggregator.getAsNumber());
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeInt(shortAsNumber.getValue().intValue());
        buffer.writeBytes(Ipv4Util.bytesForAddress((Ipv4Address)aggregator.getNetworkAddress()));
        AttributeUtil.formatAttribute((int)192, (int)7, (ByteBuf)buffer, (ByteBuf)byteAggregator);
    }
}

