/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigInteger;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.Aigp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.AigpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.aigp.AigpTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.aigp.AigpTlvBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.AccumulatedIgpMetric;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AigpAttributeParser
implements AttributeParser,
AttributeSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AigpAttributeParser.class);
    private static final byte AIGP_TLV_TYPE = 1;
    private static final short AIGP_TLV_SIZE = 11;
    private static final int TLV_SIZE_IN_BYTES = 2;
    public static final int TYPE = 26;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) throws BGPDocumentedException, BGPParsingException {
        if (!buffer.isReadable()) {
            return;
        }
        builder.setAigp(new AigpBuilder().setAigpTlv(AigpAttributeParser.parseAigpTLV(buffer)).build());
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        Aigp aigpAttribute = ((Attributes)attribute).getAigp();
        if (aigpAttribute == null) {
            return;
        }
        AttributeUtil.formatAttribute((int)128, (int)26, (ByteBuf)AigpAttributeParser.serializeAigpTLV(aigpAttribute), (ByteBuf)byteAggregator);
    }

    private static AigpTlv parseAigpTLV(ByteBuf buffer) {
        byte tlvType = buffer.readByte();
        buffer.skipBytes(2);
        if (tlvType != 1) {
            LOG.warn("AIGP attribute contains unknown TLV type {}.", (Object)tlvType);
            return null;
        }
        return new AigpTlvBuilder().setMetric(new AccumulatedIgpMetric(BigInteger.valueOf(buffer.readLong()))).build();
    }

    private static ByteBuf serializeAigpTLV(Aigp aigp) {
        AigpTlv tlv = aigp.getAigpTlv();
        if (tlv == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf value = Unpooled.buffer((int)11);
        value.writeByte(1);
        value.writeShort(11);
        value.writeLong(tlv.getMetric().getValue().longValue());
        return value;
    }
}

