/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.impl.message.update.AsPathSegmentParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.AsPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.AsPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.as.path.Segments;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.as.path.SegmentsBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsPathAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 2;
    private final ReferenceCache refCache;
    private static final Logger LOG = LoggerFactory.getLogger(AsPathAttributeParser.class);
    private static final AsPath EMPTY = new AsPathBuilder().setSegments(Collections.emptyList()).build();

    public AsPathAttributeParser(ReferenceCache refCache) {
        this.refCache = (ReferenceCache)Preconditions.checkNotNull((Object)refCache);
    }

    private static AsPath parseAsPath(ReferenceCache refCache, ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        if (!buffer.isReadable()) {
            return EMPTY;
        }
        ArrayList<Segments> ases = new ArrayList<Segments>();
        boolean isSequence = false;
        while (buffer.isReadable()) {
            short type = buffer.readUnsignedByte();
            AsPathSegmentParser.SegmentType segmentType = AsPathSegmentParser.parseType(type);
            if (segmentType == null) {
                throw new BGPParsingException("AS Path segment type unknown : " + type);
            }
            short count = buffer.readUnsignedByte();
            List<AsNumber> asList = AsPathSegmentParser.parseAsSegment(refCache, count, buffer.readSlice(count * 4));
            if (segmentType == AsPathSegmentParser.SegmentType.AS_SEQUENCE) {
                ases.add(new SegmentsBuilder().setAsSequence(asList).build());
                isSequence = true;
                continue;
            }
            ases.add(new SegmentsBuilder().setAsSet(asList).build());
        }
        if (!isSequence) {
            throw new BGPDocumentedException("AS_SEQUENCE must be present in AS_PATH attribute.", BGPError.AS_PATH_MALFORMED);
        }
        ases.trimToSize();
        return new AsPathBuilder().setSegments(ases).build();
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) throws BGPDocumentedException, BGPParsingException {
        builder.setAsPath(AsPathAttributeParser.parseAsPath(this.refCache, buffer));
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        Attributes pathAttributes = (Attributes)attribute;
        AsPath asPath = pathAttributes.getAsPath();
        if (asPath == null) {
            return;
        }
        ByteBuf segmentsBuffer = Unpooled.buffer();
        if (asPath.getSegments() != null) {
            for (Segments segments : asPath.getSegments()) {
                if (segments.getAsSequence() != null) {
                    AsPathSegmentParser.serializeAsList(segments.getAsSequence(), AsPathSegmentParser.SegmentType.AS_SEQUENCE, segmentsBuffer);
                    continue;
                }
                if (segments.getAsSet() != null) {
                    AsPathSegmentParser.serializeAsList(segments.getAsSet(), AsPathSegmentParser.SegmentType.AS_SET, segmentsBuffer);
                    continue;
                }
                LOG.warn("Segment doesn't have AsSequence nor AsSet list.");
            }
        }
        AttributeUtil.formatAttribute((int)64, (int)2, (ByteBuf)segmentsBuffer, (ByteBuf)byteAggregator);
    }
}

