/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;

public final class AsPathSegmentParser {
    public static final int AS_NUMBER_LENGTH = 4;

    private AsPathSegmentParser() {
        throw new UnsupportedOperationException();
    }

    static int serializeType(SegmentType type) {
        switch (type) {
            case AS_SET: {
                return 1;
            }
            case AS_SEQUENCE: {
                return 2;
            }
        }
        return 0;
    }

    static SegmentType parseType(int type) {
        switch (type) {
            case 1: {
                return SegmentType.AS_SET;
            }
            case 2: {
                return SegmentType.AS_SEQUENCE;
            }
        }
        return null;
    }

    static List<AsNumber> parseAsSegment(ReferenceCache refCache, int count, ByteBuf buffer) {
        ArrayList coll = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            coll.add(refCache.getSharedReference((Object)new AsNumber(Long.valueOf(buffer.readUnsignedInt()))));
        }
        return coll.isEmpty() ? Collections.emptyList() : coll;
    }

    static void serializeAsList(List<AsNumber> asList, SegmentType type, ByteBuf byteAggregator) {
        if (asList == null) {
            return;
        }
        byteAggregator.writeByte(AsPathSegmentParser.serializeType(type));
        byteAggregator.writeByte(asList.size());
        for (AsNumber asNumber : asList) {
            byteAggregator.writeInt(asNumber.getValue().intValue());
        }
    }

    public static enum SegmentType {
        AS_SEQUENCE,
        AS_SET;

    }
}

