/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.BgpPrefixSid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.BgpPrefixSidBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.bgp.prefix.sid.BgpPrefixSidTlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.bgp.prefix.sid.BgpPrefixSidTlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.bgp.prefix.sid.bgp.prefix.sid.tlvs.BgpPrefixSidTlv;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class BgpPrefixSidAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 40;
    private final BgpPrefixSidTlvRegistry reg;

    public BgpPrefixSidAttributeParser(BgpPrefixSidTlvRegistry registry) {
        this.reg = (BgpPrefixSidTlvRegistry)Preconditions.checkNotNull((Object)registry);
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        Attributes pathAttributes = (Attributes)attribute;
        BgpPrefixSid prefixSid = pathAttributes.getBgpPrefixSid();
        if (prefixSid == null) {
            return;
        }
        for (BgpPrefixSidTlvs tlv : prefixSid.getBgpPrefixSidTlvs()) {
            this.reg.serializeBgpPrefixSidTlv(tlv.getBgpPrefixSidTlv(), byteAggregator);
        }
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) throws BGPDocumentedException, BGPParsingException {
        BgpPrefixSidBuilder sid = new BgpPrefixSidBuilder();
        ArrayList<BgpPrefixSidTlvs> tlvList = new ArrayList<BgpPrefixSidTlvs>();
        while (buffer.isReadable()) {
            BgpPrefixSidTlv tlv = this.reg.parseBgpPrefixSidTlv((int)buffer.readUnsignedByte(), buffer);
            tlvList.add(new BgpPrefixSidTlvsBuilder().setBgpPrefixSidTlv(tlv).build());
        }
        builder.setBgpPrefixSid(sid.setBgpPrefixSidTlvs(tlvList).build());
    }
}

