/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.ClusterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.ClusterIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ClusterIdentifier;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class ClusterIdAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 10;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) {
        ArrayList list = Lists.newArrayList();
        while (buffer.isReadable()) {
            list.add(new ClusterIdentifier(Ipv4Util.addressForByteBuf((ByteBuf)buffer)));
        }
        builder.setClusterId(new ClusterIdBuilder().setCluster((List)list).build());
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        ClusterId cid = ((Attributes)attribute).getClusterId();
        if (cid == null) {
            return;
        }
        List cluster = cid.getCluster();
        if (cluster == null || cluster.isEmpty()) {
            return;
        }
        ByteBuf clusterIdBuffer = Unpooled.buffer();
        for (ClusterIdentifier clusterIdentifier : cid.getCluster()) {
            clusterIdBuffer.writeBytes(Ipv4Util.bytesForAddress((Ipv4Address)clusterIdentifier));
        }
        AttributeUtil.formatAttribute((int)128, (int)10, (ByteBuf)clusterIdBuffer, (ByteBuf)byteAggregator);
    }
}

