/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.impl.message.update.CommunityUtil;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.Communities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Community;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class CommunitiesAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 8;
    private static final int COMMUNITY_LENGTH = 4;
    private static final byte[] NO_EXPORT = new byte[]{-1, -1, -1, 1};
    private static final byte[] NO_ADVERTISE = new byte[]{-1, -1, -1, 2};
    private static final byte[] NO_EXPORT_SUBCONFED = new byte[]{-1, -1, -1, 3};
    private final ReferenceCache refCache;

    public CommunitiesAttributeParser(ReferenceCache refCache) {
        this.refCache = (ReferenceCache)Preconditions.checkNotNull((Object)refCache);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) throws BGPDocumentedException {
        ArrayList set = Lists.newArrayList();
        while (buffer.isReadable()) {
            set.add((Communities)CommunitiesAttributeParser.parseCommunity(this.refCache, buffer.readSlice(4)));
        }
        builder.setCommunities((List)set);
    }

    @VisibleForTesting
    public static Community parseCommunity(ReferenceCache refCache, ByteBuf buffer) throws BGPDocumentedException {
        if (buffer.readableBytes() != 4) {
            throw new BGPDocumentedException("Community with wrong length: " + buffer.readableBytes(), BGPError.OPT_ATTR_ERROR);
        }
        byte[] body = ByteArray.getBytes((ByteBuf)buffer, (int)4);
        if (Arrays.equals(body, NO_EXPORT)) {
            return CommunityUtil.NO_EXPORT;
        }
        if (Arrays.equals(body, NO_ADVERTISE)) {
            return CommunityUtil.NO_ADVERTISE;
        }
        if (Arrays.equals(body, NO_EXPORT_SUBCONFED)) {
            return CommunityUtil.NO_EXPORT_SUBCONFED;
        }
        return CommunityUtil.create(refCache, buffer.readUnsignedShort(), buffer.readUnsignedShort());
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        List communities = ((Attributes)attribute).getCommunities();
        if (communities == null || communities.isEmpty()) {
            return;
        }
        ByteBuf communitiesBuffer = Unpooled.buffer();
        for (Community community : communities) {
            communitiesBuffer.writeShort((int)community.getAsNumber().getValue().shortValue());
            communitiesBuffer.writeShort((int)community.getSemantics().shortValue());
        }
        AttributeUtil.formatAttribute((int)192, (int)8, (ByteBuf)communitiesBuffer, (ByteBuf)byteAggregator);
    }
}

