/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import org.opendaylight.protocol.util.NoopReferenceCache;
import org.opendaylight.protocol.util.ReferenceCache;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.CommunitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.Community;

public final class CommunityUtil {
    public static final Community NO_EXPORT = CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), 65535L, 65281);
    public static final Community NO_ADVERTISE = CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), 65535L, 65282);
    public static final Community NO_EXPORT_SUBCONFED = CommunityUtil.create((ReferenceCache)NoopReferenceCache.getInstance(), 65535L, 65283);
    private final ReferenceCache refCache;

    public CommunityUtil(ReferenceCache refCache) {
        this.refCache = (ReferenceCache)Preconditions.checkNotNull((Object)refCache);
    }

    public Community create(long asn, int semantics) {
        return CommunityUtil.create(this.refCache, asn, semantics);
    }

    public Community valueOf(String string) {
        return CommunityUtil.valueOf(this.refCache, string);
    }

    public static Community create(ReferenceCache refCache, long asn, int semantics) {
        CommunitiesBuilder builder = new CommunitiesBuilder();
        builder.setAsNumber((AsNumber)refCache.getSharedReference((Object)new AsNumber(Long.valueOf(asn))));
        builder.setSemantics((Integer)refCache.getSharedReference((Object)semantics));
        return (Community)refCache.getSharedReference((Object)builder.build());
    }

    public static Community valueOf(ReferenceCache refCache, String string) {
        String[] parts = string.split(":", 2);
        CommunitiesBuilder builder = new CommunitiesBuilder();
        builder.setAsNumber((AsNumber)refCache.getSharedReference((Object)new AsNumber(Long.valueOf(parts[0]))));
        builder.setSemantics((Integer)refCache.getSharedReference((Object)Integer.valueOf(parts[1])));
        return (Community)refCache.getSharedReference((Object)builder.build());
    }
}

