/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.ExtendedCommunityRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.ExtendedCommunities;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class ExtendedCommunitiesAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 16;
    private final ExtendedCommunityRegistry ecReg;

    public ExtendedCommunitiesAttributeParser(ExtendedCommunityRegistry ecReg) {
        this.ecReg = (ExtendedCommunityRegistry)Preconditions.checkNotNull((Object)ecReg);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) throws BGPDocumentedException, BGPParsingException {
        ArrayList<ExtendedCommunities> set = new ArrayList<ExtendedCommunities>();
        while (buffer.isReadable()) {
            ExtendedCommunities exComm = this.ecReg.parseExtendedCommunity(buffer);
            if (exComm == null) continue;
            set.add(exComm);
        }
        builder.setExtendedCommunities(set);
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        List communitiesList = ((Attributes)attribute).getExtendedCommunities();
        if (communitiesList == null || communitiesList.isEmpty()) {
            return;
        }
        ByteBuf extendedCommunitiesBuffer = Unpooled.buffer();
        for (ExtendedCommunities extendedCommunities : communitiesList) {
            this.ecReg.serializeExtendedCommunity(extendedCommunities, extendedCommunitiesBuffer);
        }
        if (extendedCommunitiesBuffer.readableBytes() > 0) {
            AttributeUtil.formatAttribute((int)192, (int)16, (ByteBuf)extendedCommunitiesBuffer, (ByteBuf)byteAggregator);
        }
    }
}

