/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.NlriSerializer;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.Attributes1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.Attributes1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.attributes.MpReachNlri;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class MPReachAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 14;
    private final NlriRegistry reg;

    public MPReachAttributeParser(NlriRegistry reg) {
        this.reg = (NlriRegistry)Preconditions.checkNotNull((Object)reg);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) throws BGPDocumentedException {
        this.parseAttribute(buffer, builder, null);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, PeerSpecificParserConstraint constraint) throws BGPDocumentedException {
        try {
            MpReachNlri mpReachNlri = this.reg.parseMpReach(buffer, constraint);
            Attributes1 a = new Attributes1Builder().setMpReachNlri(mpReachNlri).build();
            builder.addAugmentation(Attributes1.class, (Augmentation)a);
        }
        catch (BGPParsingException e) {
            throw new BGPDocumentedException("Could not parse MP_REACH_NLRI", BGPError.OPT_ATTR_ERROR, (Exception)((Object)e));
        }
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        Attributes pathAttributes = (Attributes)attribute;
        Attributes1 pathAttributes1 = (Attributes1)pathAttributes.getAugmentation(Attributes1.class);
        if (pathAttributes1 == null) {
            return;
        }
        MpReachNlri mpReachNlri = pathAttributes1.getMpReachNlri();
        ByteBuf reachBuffer = Unpooled.buffer();
        this.reg.serializeMpReach(mpReachNlri, reachBuffer);
        for (NlriSerializer nlriSerializer : this.reg.getSerializers()) {
            nlriSerializer.serializeAttribute(attribute, reachBuffer);
        }
        AttributeUtil.formatAttribute((int)128, (int)14, (ByteBuf)reachBuffer, (ByteBuf)byteAggregator);
    }
}

