/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.NlriSerializer;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.Attributes2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.Attributes2Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev130919.update.attributes.MpUnreachNlri;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class MPUnreachAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 15;
    private final NlriRegistry reg;

    public MPUnreachAttributeParser(NlriRegistry reg) {
        this.reg = (NlriRegistry)Preconditions.checkNotNull((Object)reg);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) throws BGPDocumentedException {
        this.parseAttribute(buffer, builder, null);
    }

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder, PeerSpecificParserConstraint constraint) throws BGPDocumentedException {
        try {
            MpUnreachNlri mpUnreachNlri = this.reg.parseMpUnreach(buffer, constraint);
            Attributes2 a = new Attributes2Builder().setMpUnreachNlri(mpUnreachNlri).build();
            builder.addAugmentation(Attributes2.class, (Augmentation)a);
        }
        catch (BGPParsingException e) {
            throw new BGPDocumentedException("Could not parse MP_UNREACH_NLRI", BGPError.OPT_ATTR_ERROR, (Exception)((Object)e));
        }
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        Attributes pathAttributes = (Attributes)attribute;
        Attributes2 pathAttributes2 = (Attributes2)pathAttributes.getAugmentation(Attributes2.class);
        if (pathAttributes2 == null) {
            return;
        }
        MpUnreachNlri mpUnreachNlri = pathAttributes2.getMpUnreachNlri();
        ByteBuf unreachBuffer = Unpooled.buffer();
        this.reg.serializeMpUnReach(mpUnreachNlri, unreachBuffer);
        for (NlriSerializer nlriSerializer : this.reg.getSerializers()) {
            nlriSerializer.serializeAttribute(attribute, unreachBuffer);
        }
        AttributeUtil.formatAttribute((int)128, (int)15, (ByteBuf)unreachBuffer, (ByteBuf)byteAggregator);
    }
}

