/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.MultiExitDisc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.MultiExitDiscBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class MultiExitDiscriminatorAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 4;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) {
        builder.setMultiExitDisc(new MultiExitDiscBuilder().setMed(Long.valueOf(buffer.readUnsignedInt())).build());
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        MultiExitDisc multiExitDisc = ((Attributes)attribute).getMultiExitDisc();
        if (multiExitDisc == null) {
            return;
        }
        AttributeUtil.formatAttribute((int)128, (int)4, (ByteBuf)Unpooled.copyInt((int)multiExitDisc.getMed().intValue()), (ByteBuf)byteAggregator);
    }
}

