/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.bgp.concepts.NextHopUtil;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.next.hop.CNextHop;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class NextHopAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 3;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) {
        Preconditions.checkArgument((buffer.readableBytes() == 4 ? 1 : 0) != 0, (String)"Length of byte array for NEXT_HOP should be %s, but is %s", (int)buffer.readableBytes(), (int)4);
        builder.setCNextHop(NextHopUtil.parseNextHop((ByteBuf)buffer));
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        CNextHop cNextHop = ((Attributes)attribute).getCNextHop();
        if (cNextHop == null) {
            return;
        }
        ByteBuf nextHopBuffer = Unpooled.buffer();
        NextHopUtil.serializeNextHop((CNextHop)cNextHop, (ByteBuf)nextHopBuffer);
        AttributeUtil.formatAttribute((int)64, (int)3, (ByteBuf)nextHopBuffer, (ByteBuf)byteAggregator);
    }
}

