/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPError;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.Origin;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.OriginBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.BgpOrigin;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class OriginAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 1;
    private static final Origin IGP = new OriginBuilder().setValue(BgpOrigin.Igp).build();
    private static final Origin EGP = new OriginBuilder().setValue(BgpOrigin.Egp).build();
    private static final Origin INC = new OriginBuilder().setValue(BgpOrigin.Incomplete).build();

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) throws BGPDocumentedException {
        byte rawOrigin = buffer.readByte();
        BgpOrigin borigin = BgpOrigin.forValue((int)UnsignedBytes.toInt((byte)rawOrigin));
        if (borigin == null) {
            throw new BGPDocumentedException("Unknown Origin type.", BGPError.ORIGIN_ATTR_NOT_VALID, new byte[]{1, 1, rawOrigin});
        }
        switch (borigin) {
            case Egp: {
                builder.setOrigin(EGP);
                return;
            }
            case Igp: {
                builder.setOrigin(IGP);
                return;
            }
            case Incomplete: {
                builder.setOrigin(INC);
                return;
            }
        }
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        Origin origin = ((Attributes)attribute).getOrigin();
        if (origin == null) {
            return;
        }
        AttributeUtil.formatAttribute((int)64, (int)1, (ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{UnsignedBytes.checkedCast((long)origin.getValue().getIntValue())}), (ByteBuf)byteAggregator);
    }
}

