/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.AttributeUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.OriginatorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev130919.path.attributes.attributes.OriginatorIdBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public final class OriginatorIdAttributeParser
implements AttributeParser,
AttributeSerializer {
    public static final int TYPE = 9;

    public void parseAttribute(ByteBuf buffer, AttributesBuilder builder) {
        Preconditions.checkArgument((buffer.readableBytes() == 4 ? 1 : 0) != 0, (String)"Length of byte array for ORIGINATOR_ID should be %s, but is %s", (int)4, (int)buffer.readableBytes());
        builder.setOriginatorId(new OriginatorIdBuilder().setOriginator(Ipv4Util.addressForByteBuf((ByteBuf)buffer)).build());
    }

    public void serializeAttribute(DataObject attribute, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(attribute instanceof Attributes), (Object)"Attribute parameter is not a PathAttribute object.");
        OriginatorId originator = ((Attributes)attribute).getOriginatorId();
        if (originator == null) {
            return;
        }
        ByteBuf originatorIdBuf = Unpooled.buffer();
        originatorIdBuf.writeBytes(Ipv4Util.bytesForAddress((Ipv4Address)originator.getOriginator()));
        AttributeUtil.formatAttribute((int)128, (int)9, (ByteBuf)originatorIdBuf, (ByteBuf)byteAggregator);
    }
}

