/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.AbstractIpv4ExtendedCommunity;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.Inet4SpecificExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.Inet4SpecificExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.inet4.specific.extended.community._case.Inet4SpecificExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.inet4.specific.extended.community._case.Inet4SpecificExtendedCommunityBuilder;

public final class Ipv4SpecificEcHandler
extends AbstractIpv4ExtendedCommunity {
    private static final int SUBTYPE = 0;

    public ExtendedCommunity parseExtendedCommunity(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        return new Inet4SpecificExtendedCommunityCaseBuilder().setInet4SpecificExtendedCommunity(new Inet4SpecificExtendedCommunityBuilder().setGlobalAdministrator(Ipv4Util.addressForByteBuf((ByteBuf)buffer)).setLocalAdministrator(ByteArray.readBytes((ByteBuf)buffer, (int)2)).build()).build();
    }

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof Inet4SpecificExtendedCommunityCase), (String)"The extended community %s is not Inet4SpecificExtendedCommunityCase type.", (Object)extendedCommunity);
        Inet4SpecificExtendedCommunity inet4SpecificExtendedCommunity = ((Inet4SpecificExtendedCommunityCase)extendedCommunity).getInet4SpecificExtendedCommunity();
        ByteBufWriteUtil.writeIpv4Address((Ipv4Address)inet4SpecificExtendedCommunity.getGlobalAdministrator(), (ByteBuf)byteAggregator);
        byteAggregator.writeBytes(inet4SpecificExtendedCommunity.getLocalAdministrator());
    }

    public int getSubType() {
        return 0;
    }
}

