/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.AbstractIpv4ExtendedCommunity;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteOriginIpv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteOriginIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.origin.ipv4._case.RouteOriginIpv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.origin.ipv4._case.RouteOriginIpv4Builder;

public final class RouteOriginIpv4EcHandler
extends AbstractIpv4ExtendedCommunity {
    private static final int SUBTYPE = 3;

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof RouteOriginIpv4Case), (String)"The extended community %s is not RouteOriginIpv4Case type.", (Object)extendedCommunity);
        RouteOriginIpv4 routeTarget = ((RouteOriginIpv4Case)extendedCommunity).getRouteOriginIpv4();
        ByteBufWriteUtil.writeIpv4Address((Ipv4Address)routeTarget.getGlobalAdministrator(), (ByteBuf)byteAggregator);
        ByteBufWriteUtil.writeUnsignedShort((Integer)routeTarget.getLocalAdministrator(), (ByteBuf)byteAggregator);
    }

    public ExtendedCommunity parseExtendedCommunity(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        RouteOriginIpv4 routeTarget = new RouteOriginIpv4Builder().setGlobalAdministrator(Ipv4Util.addressForByteBuf((ByteBuf)buffer)).setLocalAdministrator(Integer.valueOf(buffer.readUnsignedShort())).build();
        return new RouteOriginIpv4CaseBuilder().setRouteOriginIpv4(routeTarget).build();
    }

    public int getSubType() {
        return 3;
    }
}

