/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.impl.message.update.extended.communities;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.AbstractTwoOctetAsExtendedCommunity;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.ShortAsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.ExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteTargetExtendedCommunityCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.RouteTargetExtendedCommunityCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.target.extended.community._case.RouteTargetExtendedCommunity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev130919.extended.community.extended.community.route.target.extended.community._case.RouteTargetExtendedCommunityBuilder;

public final class RouteTargetAsTwoOctetEcHandler
extends AbstractTwoOctetAsExtendedCommunity {
    private static final int SUBTYPE = 2;

    public ExtendedCommunity parseExtendedCommunity(ByteBuf buffer) throws BGPDocumentedException, BGPParsingException {
        RouteTargetExtendedCommunity targetTarget = new RouteTargetExtendedCommunityBuilder().setGlobalAdministrator(new ShortAsNumber(Long.valueOf(buffer.readUnsignedShort()))).setLocalAdministrator(ByteArray.readBytes((ByteBuf)buffer, (int)4)).build();
        return new RouteTargetExtendedCommunityCaseBuilder().setRouteTargetExtendedCommunity(targetTarget).build();
    }

    public void serializeExtendedCommunity(ExtendedCommunity extendedCommunity, ByteBuf byteAggregator) {
        Preconditions.checkArgument((boolean)(extendedCommunity instanceof RouteTargetExtendedCommunityCase), (String)"The extended community %s is not RouteTargetExtendedCommunityCase type.", (Object)extendedCommunity);
        RouteTargetExtendedCommunity routeTarget = ((RouteTargetExtendedCommunityCase)extendedCommunity).getRouteTargetExtendedCommunity();
        ByteBufWriteUtil.writeUnsignedShort((Integer)Ints.checkedCast((long)routeTarget.getGlobalAdministrator().getValue()), (ByteBuf)byteAggregator);
        byteAggregator.writeBytes(routeTarget.getLocalAdministrator());
    }

    public int getSubType() {
        return 2;
    }
}

