/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupport;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupportUtil;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.UnicastSubsequentAddressFamily;

public class MultiPathSupportUtilTest {
    private static final BgpTableType AFI_SAFI = new BgpTableTypeImpl(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class);
    @Mock
    private PeerSpecificParserConstraint constraints;
    @Mock
    private MultiPathSupport mpSupport;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testIsTableTypeSupportedPossitive() {
        ((PeerSpecificParserConstraint)Mockito.doReturn(Optional.of(this.mpSupport)).when((Object)this.constraints)).getPeerConstraint((Class)Mockito.any());
        ((MultiPathSupport)Mockito.doReturn((Object)true).when((Object)this.mpSupport)).isTableTypeSupported((BgpTableType)Mockito.any());
        Assert.assertTrue((boolean)MultiPathSupportUtil.isTableTypeSupported((PeerSpecificParserConstraint)this.constraints, (BgpTableType)AFI_SAFI));
    }

    @Test
    public void testIsTableTypeSupportedNegativeTableTypeNotSupported() {
        ((PeerSpecificParserConstraint)Mockito.doReturn(Optional.of(this.mpSupport)).when((Object)this.constraints)).getPeerConstraint((Class)Mockito.any());
        ((MultiPathSupport)Mockito.doReturn((Object)false).when((Object)this.mpSupport)).isTableTypeSupported((BgpTableType)Mockito.any());
        Assert.assertFalse((boolean)MultiPathSupportUtil.isTableTypeSupported((PeerSpecificParserConstraint)this.constraints, (BgpTableType)AFI_SAFI));
    }

    @Test
    public void testIsTableTypeSupportedNegativeMpSupportAbsent() {
        ((PeerSpecificParserConstraint)Mockito.doReturn(Optional.empty()).when((Object)this.constraints)).getPeerConstraint((Class)Mockito.any());
        Assert.assertFalse((boolean)MultiPathSupportUtil.isTableTypeSupported((PeerSpecificParserConstraint)this.constraints, (BgpTableType)AFI_SAFI));
    }

    @Test
    public void testIsTableTypeSupportedNegativeNull() {
        Assert.assertFalse((boolean)MultiPathSupportUtil.isTableTypeSupported(null, (BgpTableType)AFI_SAFI));
    }

    @Test(expected=NullPointerException.class)
    public void testIsTableTypeSupportedNPE() {
        MultiPathSupportUtil.isTableTypeSupported(null, null);
    }
}

