/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.extended.community;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.spi.extended.community.Inet4SpecificExtendedCommunityCommonUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommon;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.inet4.specific.extended.community.common.Inet4SpecificExtendedCommunityCommonBuilder;

public class Inet4SpecificExtendedCommunityCommonUtilTest {
    private static final byte[] INPUT = new byte[]{12, 51, 2, 5, 21, 45};

    @Test
    public void testHandle() {
        Inet4SpecificExtendedCommunityCommon expected = new Inet4SpecificExtendedCommunityCommonBuilder().setGlobalAdministrator(new Ipv4Address("12.51.2.5")).setLocalAdministrator(new byte[]{21, 45}).build();
        Inet4SpecificExtendedCommunityCommon exComm = Inet4SpecificExtendedCommunityCommonUtil.parseCommon((ByteBuf)Unpooled.copiedBuffer((byte[])INPUT));
        Assert.assertEquals((Object)expected, (Object)exComm);
        ByteBuf output = Unpooled.buffer((int)INPUT.length);
        Inet4SpecificExtendedCommunityCommonUtil.serializeCommon((Inet4SpecificExtendedCommunityCommon)expected, (ByteBuf)output);
        Assert.assertArrayEquals((byte[])INPUT, (byte[])output.array());
    }
}

