/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupport;
import org.opendaylight.protocol.bgp.parser.spi.pojo.MultiPathSupportImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.SendReceive;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamilies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.mp.capabilities.add.path.capability.AddressFamiliesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.MplsLabeledVpnSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.UnicastSubsequentAddressFamily;

public class MultiPathSupportImplTest {
    @Test(expected=NullPointerException.class)
    public void testcreateParserMultiPathSupportNull() {
        MultiPathSupportImpl.createParserMultiPathSupport(null);
    }

    @Test
    public void testIsTableTypeSupported() {
        ArrayList supportedTables = Lists.newArrayList();
        BgpTableTypeImpl ipv4Unicast = new BgpTableTypeImpl(Ipv4AddressFamily.class, UnicastSubsequentAddressFamily.class);
        BgpTableTypeImpl ipv4L3vpn = new BgpTableTypeImpl(Ipv4AddressFamily.class, MplsLabeledVpnSubsequentAddressFamily.class);
        BgpTableTypeImpl ipv6Unicast = new BgpTableTypeImpl(Ipv6AddressFamily.class, UnicastSubsequentAddressFamily.class);
        BgpTableTypeImpl ipv6L3vpn = new BgpTableTypeImpl(Ipv6AddressFamily.class, MplsLabeledVpnSubsequentAddressFamily.class);
        supportedTables.add(MultiPathSupportImplTest.createAddPathCapability((BgpTableType)ipv4Unicast, SendReceive.Send));
        supportedTables.add(MultiPathSupportImplTest.createAddPathCapability((BgpTableType)ipv4L3vpn, SendReceive.Receive));
        supportedTables.add(MultiPathSupportImplTest.createAddPathCapability((BgpTableType)ipv6Unicast, SendReceive.Both));
        MultiPathSupport multiPathSupport = MultiPathSupportImpl.createParserMultiPathSupport((List)supportedTables);
        Assert.assertTrue((boolean)multiPathSupport.isTableTypeSupported((BgpTableType)ipv4Unicast));
        Assert.assertTrue((boolean)multiPathSupport.isTableTypeSupported((BgpTableType)ipv6Unicast));
        Assert.assertFalse((boolean)multiPathSupport.isTableTypeSupported((BgpTableType)ipv4L3vpn));
        Assert.assertFalse((boolean)multiPathSupport.isTableTypeSupported((BgpTableType)ipv6L3vpn));
    }

    private static AddressFamilies createAddPathCapability(BgpTableType afisafi, SendReceive mode) {
        return new AddressFamiliesBuilder().setAfi(afisafi.getAfi()).setSafi(afisafi.getSafi()).setSendReceive(mode).build();
    }
}

