/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.AttributeRegistry;
import org.opendaylight.protocol.bgp.parser.spi.AttributeSerializer;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvParser;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvRegistry;
import org.opendaylight.protocol.bgp.parser.spi.BgpPrefixSidTlvSerializer;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityParser;
import org.opendaylight.protocol.bgp.parser.spi.CapabilityRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageParser;
import org.opendaylight.protocol.bgp.parser.spi.MessageRegistry;
import org.opendaylight.protocol.bgp.parser.spi.MessageSerializer;
import org.opendaylight.protocol.bgp.parser.spi.MultiPathSupport;
import org.opendaylight.protocol.bgp.parser.spi.NlriParser;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterParser;
import org.opendaylight.protocol.bgp.parser.spi.ParameterRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterSerializer;
import org.opendaylight.protocol.bgp.parser.spi.PeerConstraint;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.pojo.BgpTestActivator;
import org.opendaylight.protocol.bgp.parser.spi.pojo.ServiceLoaderBGPExtensionProviderContext;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.BgpParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.Attributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.attributes.bgp.prefix.sid.bgp.prefix.sid.tlvs.BgpPrefixSidTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpUnreachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpUnreachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.Ipv4AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.Ipv6AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.UnicastSubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.next.hop.CNextHop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.next.hop.c.next.hop.Ipv4NextHopCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.next.hop.c.next.hop.ipv4.next.hop._case.Ipv4NextHopBuilder;
import org.opendaylight.yangtools.yang.binding.Notification;

public class SimpleRegistryTest {
    private static final MultiPathSupport ADD_PATH_SUPPORT = tableType -> true;
    private static final PeerSpecificParserConstraint CONSTRAINT = new PeerSpecificParserConstraint(){

        public <T extends PeerConstraint> Optional<T> getPeerConstraint(Class<T> peerConstraintType) {
            return Optional.of(ADD_PATH_SUPPORT);
        }
    };
    protected BGPExtensionProviderContext ctx;
    private BgpTestActivator activator;

    @Before
    public void setUp() {
        this.ctx = ServiceLoaderBGPExtensionProviderContext.getSingletonInstance();
        this.activator = new BgpTestActivator();
        this.activator.start(this.ctx);
    }

    @After
    public void tearDown() {
        this.activator.close();
    }

    @Test
    public void testSimpleAttribute() throws BGPDocumentedException, BGPParsingException {
        AttributeRegistry attrReg = this.ctx.getAttributeRegistry();
        byte[] attributeBytes = new byte[]{0, 0, 0};
        ByteBuf byteAggregator = Unpooled.buffer((int)attributeBytes.length);
        attrReg.serializeAttribute((Attributes)Mockito.mock(Attributes.class), byteAggregator);
        attrReg.parseAttributes(Unpooled.wrappedBuffer((byte[])attributeBytes), CONSTRAINT);
        ((AttributeParser)Mockito.verify((Object)this.activator.attrParser, (VerificationMode)Mockito.times((int)1))).parseAttribute((ByteBuf)Matchers.any(ByteBuf.class), (AttributesBuilder)Matchers.any(AttributesBuilder.class), (PeerSpecificParserConstraint)Matchers.any(PeerSpecificParserConstraint.class));
        ((AttributeSerializer)Mockito.verify((Object)this.activator.attrSerializer, (VerificationMode)Mockito.times((int)1))).serializeAttribute((Attributes)Matchers.any(Attributes.class), (ByteBuf)Matchers.any(ByteBuf.class));
    }

    @Test
    public void testSimpleParameter() throws Exception {
        ParameterRegistry paramReg = this.ctx.getParameterRegistry();
        BgpParameters param = (BgpParameters)Mockito.mock(BgpParameters.class);
        ((BgpParameters)Mockito.doReturn(BgpParameters.class).when((Object)param)).getImplementedInterface();
        byte[] paramBytes = new byte[]{0, 0};
        ByteBuf buffer = Unpooled.buffer((int)paramBytes.length);
        paramReg.serializeParameter(param, buffer);
        paramReg.parseParameter(0, Unpooled.wrappedBuffer((byte[])paramBytes));
        ((ParameterParser)Mockito.verify((Object)this.activator.paramParser, (VerificationMode)Mockito.times((int)1))).parseParameter((ByteBuf)Matchers.any(ByteBuf.class));
        ((ParameterSerializer)Mockito.verify((Object)this.activator.paramSerializer, (VerificationMode)Mockito.times((int)1))).serializeParameter((BgpParameters)Matchers.any(BgpParameters.class), (ByteBuf)Matchers.any(ByteBuf.class));
    }

    @Test
    public void testSimpleCapability() throws Exception {
        CapabilityRegistry capaRegistry = this.ctx.getCapabilityRegistry();
        byte[] capabilityBytes = new byte[]{0, 0};
        capaRegistry.parseCapability(0, Unpooled.wrappedBuffer((byte[])capabilityBytes));
        ((CapabilityParser)Mockito.verify((Object)this.activator.capaParser, (VerificationMode)Mockito.times((int)1))).parseCapability((ByteBuf)Matchers.any(ByteBuf.class));
    }

    @Test
    public void testSimpleBgpPrefixSidTlvRegistry() {
        BgpPrefixSidTlvRegistry sidTlvReg = this.ctx.getBgpPrefixSidTlvRegistry();
        byte[] tlvBytes = new byte[]{0, 3, 0, 0, 0};
        BgpPrefixSidTlv tlv = (BgpPrefixSidTlv)Mockito.mock(BgpPrefixSidTlv.class);
        ((BgpPrefixSidTlv)Mockito.doReturn(BgpPrefixSidTlv.class).when((Object)tlv)).getImplementedInterface();
        ByteBuf buffer = Unpooled.buffer((int)tlvBytes.length);
        sidTlvReg.serializeBgpPrefixSidTlv(tlv, buffer);
        ((BgpPrefixSidTlvSerializer)Mockito.verify((Object)this.activator.sidTlvSerializer, (VerificationMode)Mockito.times((int)1))).serializeBgpPrefixSidTlv((BgpPrefixSidTlv)Matchers.any(BgpPrefixSidTlv.class), (ByteBuf)Matchers.any(ByteBuf.class));
        sidTlvReg.parseBgpPrefixSidTlv(0, Unpooled.wrappedBuffer((byte[])tlvBytes));
        ((BgpPrefixSidTlvParser)Mockito.verify((Object)this.activator.sidTlvParser, (VerificationMode)Mockito.times((int)1))).parseBgpPrefixSidTlv((ByteBuf)Matchers.any(ByteBuf.class));
    }

    @Test
    public void testSimpleMessageRegistry() throws Exception {
        MessageRegistry msgRegistry = this.ctx.getMessageRegistry();
        byte[] msgBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 19, 0};
        Notification msg = (Notification)Mockito.mock(Notification.class);
        ((Notification)Mockito.doReturn(Notification.class).when((Object)msg)).getImplementedInterface();
        ByteBuf buffer = Unpooled.buffer((int)msgBytes.length);
        msgRegistry.serializeMessage(msg, buffer);
        msgRegistry.parseMessage(Unpooled.wrappedBuffer((byte[])msgBytes), CONSTRAINT);
        ((MessageParser)Mockito.verify((Object)this.activator.msgParser, (VerificationMode)Mockito.times((int)1))).parseMessageBody((ByteBuf)Matchers.any(ByteBuf.class), Mockito.anyInt(), (PeerSpecificParserConstraint)Matchers.any(PeerSpecificParserConstraint.class));
        ((MessageSerializer)Mockito.verify((Object)this.activator.msgSerializer, (VerificationMode)Mockito.times((int)1))).serializeMessage((Notification)Matchers.any(Notification.class), (ByteBuf)Matchers.any(ByteBuf.class));
    }

    @Test
    public void testAfiRegistry() throws Exception {
        AddressFamilyRegistry afiRegistry = this.ctx.getAddressFamilyRegistry();
        Assert.assertEquals(Ipv4AddressFamily.class, (Object)afiRegistry.classForFamily(1));
        Assert.assertEquals((long)1L, (long)afiRegistry.numberForClass(Ipv4AddressFamily.class).intValue());
    }

    @Test
    public void testSafiRegistry() throws Exception {
        SubsequentAddressFamilyRegistry safiRegistry = this.ctx.getSubsequentAddressFamilyRegistry();
        Assert.assertEquals(UnicastSubsequentAddressFamily.class, (Object)safiRegistry.classForFamily(1));
        Assert.assertEquals((long)1L, (long)safiRegistry.numberForClass(UnicastSubsequentAddressFamily.class).intValue());
    }

    @Test
    public void testMpReachParser() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpReachBytes = new byte[]{0, 1, 1, 4, 127, 0, 0, 1, 0};
        MpReachNlri mpReach = new MpReachNlriBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).setCNextHop((CNextHop)new Ipv4NextHopCaseBuilder().setIpv4NextHop(new Ipv4NextHopBuilder().setGlobal(new Ipv4Address("127.0.0.1")).build()).build()).build();
        ByteBuf buffer = Unpooled.buffer((int)mpReachBytes.length);
        nlriReg.serializeMpReach(mpReach, buffer);
        Assert.assertArrayEquals((byte[])mpReachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpReach, (Object)nlriReg.parseMpReach(Unpooled.wrappedBuffer((byte[])mpReachBytes), CONSTRAINT));
        ((NlriParser)Mockito.verify((Object)this.activator.nlriParser, (VerificationMode)Mockito.times((int)1))).parseNlri((ByteBuf)Matchers.any(ByteBuf.class), (MpReachNlriBuilder)Matchers.any(MpReachNlriBuilder.class), (PeerSpecificParserConstraint)Matchers.any());
    }

    @Test
    public void testMpReachWithZeroNextHop() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpReachBytes = new byte[]{0, 1, 1, 0, 0};
        MpReachNlri mpReach = new MpReachNlriBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build();
        ByteBuf buffer = Unpooled.buffer((int)mpReachBytes.length);
        nlriReg.serializeMpReach(mpReach, buffer);
        Assert.assertArrayEquals((byte[])mpReachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpReach, (Object)nlriReg.parseMpReach(Unpooled.wrappedBuffer((byte[])mpReachBytes), CONSTRAINT));
    }

    @Test
    public void testMpReachIpv6() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpReachBytes = new byte[]{0, 2, 1, 0, 0};
        MpReachNlri mpReach = new MpReachNlriBuilder().setAfi(Ipv6AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build();
        ByteBuf buffer = Unpooled.buffer((int)mpReachBytes.length);
        nlriReg.serializeMpReach(mpReach, buffer);
        Assert.assertArrayEquals((byte[])mpReachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpReach, (Object)nlriReg.parseMpReach(Unpooled.wrappedBuffer((byte[])mpReachBytes), CONSTRAINT));
    }

    @Test
    public void testMpUnReachParser() throws BGPParsingException {
        NlriRegistry nlriReg = this.ctx.getNlriRegistry();
        byte[] mpUnreachBytes = new byte[]{0, 1, 1};
        MpUnreachNlri mpUnreach = new MpUnreachNlriBuilder().setAfi(Ipv4AddressFamily.class).setSafi(UnicastSubsequentAddressFamily.class).build();
        ByteBuf buffer = Unpooled.buffer((int)mpUnreachBytes.length);
        nlriReg.serializeMpUnReach(mpUnreach, buffer);
        Assert.assertArrayEquals((byte[])mpUnreachBytes, (byte[])buffer.array());
        Assert.assertEquals((Object)mpUnreach, (Object)nlriReg.parseMpUnreach(Unpooled.wrappedBuffer((byte[])mpUnreachBytes), CONSTRAINT));
        ((NlriParser)Mockito.verify((Object)this.activator.nlriParser, (VerificationMode)Mockito.times((int)1))).parseNlri((ByteBuf)Matchers.any(ByteBuf.class), (MpUnreachNlriBuilder)Matchers.any(MpUnreachNlriBuilder.class), (PeerSpecificParserConstraint)Matchers.any());
    }
}

