/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.bgp.parser.BGPDocumentedException;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BGPTreatAsWithdrawException;
import org.opendaylight.protocol.bgp.parser.spi.AttributeParser;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.RevisedErrorHandling;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.path.attributes.AttributesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttributeParser
implements AttributeParser {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAttributeParser.class);

    @Override
    public final void parseAttribute(ByteBuf buffer, AttributesBuilder builder, PeerSpecificParserConstraint constraint) throws BGPDocumentedException, BGPParsingException {
        try {
            this.parseAttribute(buffer, builder, RevisedErrorHandling.NONE, constraint);
        }
        catch (BGPTreatAsWithdrawException e) {
            LOG.warn("Encountered misreported error", (Throwable)e);
            throw new BGPDocumentedException(e.getMessage(), e.getError(), (Exception)((Object)e));
        }
    }

    @Override
    public abstract void parseAttribute(ByteBuf var1, AttributesBuilder var2, RevisedErrorHandling var3, PeerSpecificParserConstraint var4) throws BGPDocumentedException, BGPParsingException, BGPTreatAsWithdrawException;
}

