/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderActivator;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.opendaylight.yangtools.concepts.Registration;

public abstract class AbstractBGPExtensionProviderActivator
implements AutoCloseable,
BGPExtensionProviderActivator {
    private @GuardedBy(value={"this"}) List<? extends Registration> registrations;

    @Holding(value={"this"})
    protected abstract List<? extends Registration> startImpl(BGPExtensionProviderContext var1);

    @Override
    public final synchronized void start(BGPExtensionProviderContext context) {
        Preconditions.checkState((this.registrations == null ? 1 : 0) != 0);
        this.registrations = Objects.requireNonNull(this.startImpl(context));
    }

    @Override
    public final synchronized void stop() {
        if (this.registrations == null) {
            return;
        }
        this.registrations.forEach(Registration::close);
        this.registrations = null;
    }

    @Override
    public final void close() {
        this.stop();
    }
}

