/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import io.netty.buffer.ByteBuf;

public final class AttributeUtil {
    private static final int MAX_ATTR_LENGTH_FOR_SINGLE_BYTE = 255;
    public static final int OPTIONAL = 128;
    public static final int TRANSITIVE = 64;
    public static final int PARTIAL = 32;
    private static final int EXTENDED = 16;

    private AttributeUtil() {
    }

    public static void formatAttribute(int flags, int type, ByteBuf value, ByteBuf buffer) {
        int length = value.writerIndex();
        boolean extended = length > 255;
        buffer.writeByte(extended ? flags | 0x10 : flags);
        buffer.writeByte(type);
        if (extended) {
            buffer.writeShort(length);
        } else {
            buffer.writeByte(length);
        }
        buffer.writeBytes(value);
    }
}

