/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.PathId;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.ImmutableOffsetMapTemplate;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;

public final class PathIdUtil {
    public static final long NON_PATH_ID_VALUE = 0L;
    public static final PathId NON_PATH_ID = new PathId(Long.valueOf(0L));

    private PathIdUtil() {
        throw new UnsupportedOperationException();
    }

    public static void writePathId(PathId pathId, ByteBuf buffer) {
        if (pathId != null && pathId.getValue() != 0L) {
            ByteBufWriteUtil.writeUnsignedInt((Long)pathId.getValue(), (ByteBuf)buffer);
        }
    }

    public static PathId readPathId(ByteBuf buffer) {
        Preconditions.checkArgument((buffer != null && buffer.isReadable(4) ? 1 : 0) != 0);
        return new PathId(Long.valueOf(buffer.readUnsignedInt()));
    }

    public static Long extractPathId(NormalizedNode<?, ?> data, YangInstanceIdentifier.NodeIdentifier pathNii) {
        return NormalizedNodes.findNode(data, (YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{pathNii}).map(NormalizedNode::getValue).orElse(null);
    }

    public static PathId buildPathId(DataContainerNode<? extends YangInstanceIdentifier.PathArgument> routesCont, YangInstanceIdentifier.NodeIdentifier pathIdNii) {
        Long pathIdVal = PathIdUtil.extractPathId(routesCont, pathIdNii);
        return pathIdVal == null ? null : new PathId(pathIdVal);
    }

    public static YangInstanceIdentifier.NodeIdentifierWithPredicates createNidKey(QName routeQName, ImmutableOffsetMapTemplate<QName> routeKeyTemplate, Object routeKeyValue, Optional<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> maybePathIdLeaf) {
        Long pathId = maybePathIdLeaf.isPresent() ? maybePathIdLeaf.get().getValue() : Long.valueOf(0L);
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)routeQName, (ImmutableOffsetMap)routeKeyTemplate.instantiateWithValues(new Object[]{pathId, routeKeyValue}));
    }
}

