/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.protocol.bgp.parser.spi.PeerConstraint;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraintProvider;

public class PeerSpecificParserConstraintImpl
implements PeerSpecificParserConstraintProvider {
    private static final AtomicReferenceFieldUpdater<PeerSpecificParserConstraintImpl, ImmutableClassToInstanceMap> CONSTRAINTS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PeerSpecificParserConstraintImpl.class, ImmutableClassToInstanceMap.class, "constraints");
    private volatile ImmutableClassToInstanceMap<PeerConstraint> constraints = ImmutableClassToInstanceMap.of();

    @Override
    public <T extends PeerConstraint> Optional<T> getPeerConstraint(Class<T> peerConstraintType) {
        return Optional.ofNullable(this.constraints.getInstance(peerConstraintType));
    }

    @Override
    public <T extends PeerConstraint> boolean addPeerConstraint(Class<T> classType, T peerConstraint) {
        Objects.requireNonNull(classType);
        Objects.requireNonNull(peerConstraint);
        ImmutableClassToInstanceMap<PeerConstraint> local = this.constraints;
        while (!local.containsKey(classType)) {
            ImmutableClassToInstanceMap.Builder builder = ImmutableClassToInstanceMap.builder();
            builder.putAll(local);
            builder.put(classType, peerConstraint);
            if (CONSTRAINTS_UPDATER.compareAndSet(this, local, builder.build())) {
                return true;
            }
            local = this.constraints;
        }
        return false;
    }
}

