/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderActivator;
import org.opendaylight.protocol.bgp.parser.spi.BGPExtensionProviderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBGPExtensionProviderContextActivator
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleBGPExtensionProviderContextActivator.class);
    private final BGPExtensionProviderContext providerContext;
    private final List<BGPExtensionProviderActivator> extensionActivators;

    public SimpleBGPExtensionProviderContextActivator(BGPExtensionProviderContext providerContext, List<BGPExtensionProviderActivator> extensionActivators) {
        this.providerContext = Objects.requireNonNull(providerContext);
        this.extensionActivators = Objects.requireNonNull(extensionActivators);
    }

    public void start() {
        LOG.debug("Starting {} BGPExtensionProviderActivator instances", (Object)this.extensionActivators.size());
        for (BGPExtensionProviderActivator e : this.extensionActivators) {
            e.start(this.providerContext);
        }
    }

    @Override
    public void close() {
        LOG.debug("Stopping {} BGPExtensionProviderActivator instances", (Object)this.extensionActivators.size());
        for (BGPExtensionProviderActivator e : this.extensionActivators) {
            e.stop();
        }
    }
}

