/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.bgp.concepts.NextHopUtil;
import org.opendaylight.protocol.bgp.parser.BGPParsingException;
import org.opendaylight.protocol.bgp.parser.BgpTableTypeImpl;
import org.opendaylight.protocol.bgp.parser.spi.AddressFamilyRegistry;
import org.opendaylight.protocol.bgp.parser.spi.NextHopParserSerializer;
import org.opendaylight.protocol.bgp.parser.spi.NlriParser;
import org.opendaylight.protocol.bgp.parser.spi.NlriRegistry;
import org.opendaylight.protocol.bgp.parser.spi.NlriSerializer;
import org.opendaylight.protocol.bgp.parser.spi.PeerSpecificParserConstraint;
import org.opendaylight.protocol.bgp.parser.spi.SubsequentAddressFamilyRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.BgpTableType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpReachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpReachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpUnreachNlri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.MpUnreachNlriBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.multiprotocol.rev180329.update.attributes.mp.unreach.nlri.WithdrawnRoutesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.SubsequentAddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.types.rev180329.next.hop.CNextHop;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleNlriRegistry
implements NlriRegistry {
    private static final int RESERVED = 1;
    private static final int NEXT_HOP_LENGHT = 1;
    private static final String PARSER_NOT_FOUND = "Nlri parser not found for table type {}";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleNlriRegistry.class);
    private final ConcurrentMap<BgpTableType, NlriParser> handlers = new ConcurrentHashMap<BgpTableType, NlriParser>();
    private final ConcurrentMap<Class<? extends DataObject>, NlriSerializer> serializers = new ConcurrentHashMap<Class<? extends DataObject>, NlriSerializer>();
    private final ConcurrentMap<BgpTableType, NextHopParserSerializer> nextHopParsers = new ConcurrentHashMap<BgpTableType, NextHopParserSerializer>();
    private final ConcurrentMap<Map.Entry<Class<? extends CNextHop>, BgpTableType>, NextHopParserSerializer> nextHopSerializers = new ConcurrentHashMap<Map.Entry<Class<? extends CNextHop>, BgpTableType>, NextHopParserSerializer>();
    private final SubsequentAddressFamilyRegistry safiReg;
    private final AddressFamilyRegistry afiReg;

    SimpleNlriRegistry(AddressFamilyRegistry afiReg, SubsequentAddressFamilyRegistry safiReg) {
        this.afiReg = Objects.requireNonNull(afiReg);
        this.safiReg = Objects.requireNonNull(safiReg);
    }

    private static BgpTableType createKey(Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi) {
        Objects.requireNonNull(afi);
        Objects.requireNonNull(safi);
        return new BgpTableTypeImpl(afi, safi);
    }

    synchronized Registration registerNlriSerializer(final Class<? extends DataObject> nlriClass, NlriSerializer serializer) {
        NlriSerializer prev = (NlriSerializer)this.serializers.get(nlriClass);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (Object)("Serializer already bound to class " + prev));
        this.serializers.put(nlriClass, serializer);
        final SimpleNlriRegistry lock = this;
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                Object object = lock;
                synchronized (object) {
                    SimpleNlriRegistry.this.serializers.remove(nlriClass);
                }
            }
        };
    }

    synchronized Registration registerNlriParser(Class<? extends AddressFamily> afi, Class<? extends SubsequentAddressFamily> safi, NlriParser parser, NextHopParserSerializer nextHopSerializer, final Class<? extends CNextHop> cnextHopClass, final Class<? extends CNextHop> ... cnextHopClassList) {
        final BgpTableType key = SimpleNlriRegistry.createKey(afi, safi);
        NlriParser prev = (NlriParser)this.handlers.get(key);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (Object)("AFI/SAFI is already bound to parser " + prev));
        this.handlers.put(key, parser);
        this.nextHopParsers.put(key, nextHopSerializer);
        if (cnextHopClass != null) {
            AbstractMap.SimpleEntry<Class<? extends CNextHop>, BgpTableType> nhKey = new AbstractMap.SimpleEntry<Class<? extends CNextHop>, BgpTableType>(cnextHopClass, key);
            this.nextHopSerializers.put(nhKey, nextHopSerializer);
            for (Class<? extends CNextHop> cnextHop : cnextHopClassList) {
                AbstractMap.SimpleEntry<Class<? extends CNextHop>, BgpTableType> nhKeys = new AbstractMap.SimpleEntry<Class<? extends CNextHop>, BgpTableType>(cnextHop, key);
                this.nextHopSerializers.put(nhKeys, nextHopSerializer);
            }
        }
        final SimpleNlriRegistry lock = this;
        return new AbstractRegistration(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                Object object = lock;
                synchronized (object) {
                    SimpleNlriRegistry.this.handlers.remove(key);
                    SimpleNlriRegistry.this.nextHopParsers.remove(key);
                    if (cnextHopClass != null) {
                        AbstractMap.SimpleEntry<Class, BgpTableType> nhKey = new AbstractMap.SimpleEntry<Class, BgpTableType>(cnextHopClass, key);
                        SimpleNlriRegistry.this.nextHopSerializers.remove(nhKey);
                        for (Class cnextHop : cnextHopClassList) {
                            AbstractMap.SimpleEntry<Class, BgpTableType> nhKeys = new AbstractMap.SimpleEntry<Class, BgpTableType>(cnextHop, key);
                            SimpleNlriRegistry.this.nextHopSerializers.remove(nhKeys);
                        }
                    }
                }
            }
        };
    }

    private Class<? extends AddressFamily> getAfi(ByteBuf buffer) throws BGPParsingException {
        int afiVal = buffer.readUnsignedShort();
        Class<? extends AddressFamily> afi = this.afiReg.classForFamily(afiVal);
        if (afi == null) {
            throw new BGPParsingException("Address Family Identifier: '" + afiVal + "' not supported.");
        }
        return afi;
    }

    private Class<? extends SubsequentAddressFamily> getSafi(ByteBuf buffer) throws BGPParsingException {
        short safiVal = buffer.readUnsignedByte();
        Class<? extends SubsequentAddressFamily> safi = this.safiReg.classForFamily(safiVal);
        if (safi == null) {
            throw new BGPParsingException("Subsequent Address Family Identifier: '" + safiVal + "' not supported.");
        }
        return safi;
    }

    @Override
    public MpUnreachNlri parseMpUnreach(ByteBuf buffer, PeerSpecificParserConstraint constraint) throws BGPParsingException {
        MpUnreachNlriBuilder builder = new MpUnreachNlriBuilder();
        builder.setAfi(this.getAfi(buffer));
        builder.setSafi(this.getSafi(buffer));
        if (buffer.isReadable()) {
            ByteBuf nlri = buffer.slice();
            BgpTableType key = SimpleNlriRegistry.createKey(builder.getAfi(), builder.getSafi());
            NlriParser parser = (NlriParser)this.handlers.get(key);
            if (parser == null) {
                LOG.warn(PARSER_NOT_FOUND, (Object)key);
            } else {
                parser.parseNlri(nlri, builder, constraint);
            }
        }
        return builder.build();
    }

    @Override
    public void serializeMpReach(MpReachNlri mpReachNlri, ByteBuf byteAggregator) {
        Class afi = mpReachNlri.getAfi();
        Class safi = mpReachNlri.getSafi();
        byteAggregator.writeShort(this.afiReg.numberForClass(afi).intValue());
        byteAggregator.writeByte(this.safiReg.numberForClass(safi).intValue());
        CNextHop cNextHop = mpReachNlri.getCNextHop();
        if (cNextHop != null) {
            AbstractMap.SimpleEntry<Class, BgpTableTypeImpl> key = new AbstractMap.SimpleEntry<Class, BgpTableTypeImpl>(cNextHop.implementedInterface(), new BgpTableTypeImpl(afi, safi));
            NextHopParserSerializer nextHopSerializer = (NextHopParserSerializer)this.nextHopSerializers.get(key);
            ByteBuf nextHopBuffer = Unpooled.buffer();
            nextHopSerializer.serializeNextHop(cNextHop, nextHopBuffer);
            byteAggregator.writeByte(nextHopBuffer.writerIndex());
            byteAggregator.writeBytes(nextHopBuffer);
        } else {
            byteAggregator.writeZero(1);
        }
        byteAggregator.writeZero(1);
    }

    @Override
    public void serializeMpUnReach(MpUnreachNlri mpUnreachNlri, ByteBuf byteAggregator) {
        byteAggregator.writeShort(this.afiReg.numberForClass(mpUnreachNlri.getAfi()).intValue());
        byteAggregator.writeByte(this.safiReg.numberForClass(mpUnreachNlri.getSafi()).intValue());
    }

    @Override
    public Iterable<NlriSerializer> getSerializers() {
        return Iterables.unmodifiableIterable(this.serializers.values());
    }

    @Override
    public MpReachNlri parseMpReach(ByteBuf buffer, PeerSpecificParserConstraint constraint) throws BGPParsingException {
        MpReachNlriBuilder builder = new MpReachNlriBuilder();
        Class<? extends AddressFamily> afi = this.getAfi(buffer);
        Class<? extends SubsequentAddressFamily> safi = this.getSafi(buffer);
        builder.setAfi(afi);
        builder.setSafi(safi);
        BgpTableType key = SimpleNlriRegistry.createKey(builder.getAfi(), builder.getSafi());
        short nextHopLength = buffer.readUnsignedByte();
        if (nextHopLength != 0) {
            NextHopParserSerializer nextHopParser = (NextHopParserSerializer)this.nextHopParsers.get(key);
            if (nextHopParser != null) {
                builder.setCNextHop(nextHopParser.parseNextHop(buffer.readSlice((int)nextHopLength)));
            } else {
                builder.setCNextHop(NextHopUtil.parseNextHop((ByteBuf)buffer.readSlice((int)nextHopLength)));
                LOG.warn("NexHop Parser/Serializer for AFI/SAFI ({},{}) not bound", afi, safi);
            }
        }
        buffer.skipBytes(1);
        ByteBuf nlri = buffer.slice();
        NlriParser parser = (NlriParser)this.handlers.get(key);
        if (parser == null) {
            LOG.warn(PARSER_NOT_FOUND, (Object)key);
        } else {
            parser.parseNlri(nlri, builder, constraint);
        }
        return builder.build();
    }

    @Override
    public Optional<MpUnreachNlri> convertMpReachToMpUnReach(MpReachNlri mpReachNlri, MpUnreachNlri mpUnreachNlri) {
        if (mpUnreachNlri == null) {
            return Optional.of(new MpUnreachNlriBuilder().setWithdrawnRoutes(new WithdrawnRoutesBuilder().setDestinationType(mpReachNlri.getAdvertizedRoutes().getDestinationType()).build()).build());
        }
        BgpTableType key = SimpleNlriRegistry.createKey(mpUnreachNlri.getAfi(), mpUnreachNlri.getSafi());
        NlriParser parser = (NlriParser)this.handlers.get(key);
        if (parser == null) {
            LOG.debug("Parser for {} not found", (Object)key);
            return Optional.empty();
        }
        MpUnreachNlriBuilder builder = new MpUnreachNlriBuilder(mpUnreachNlri);
        return parser.convertMpReachToMpUnReach(mpReachNlri, builder) ? Optional.of(builder.build()) : Optional.empty();
    }
}

