/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.bgp.parser.spi.pojo;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.opendaylight.protocol.bgp.parser.spi.ParameterParser;
import org.opendaylight.protocol.bgp.parser.spi.ParameterRegistry;
import org.opendaylight.protocol.bgp.parser.spi.ParameterSerializer;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.bgp.message.rev180329.open.message.BgpParameters;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataContainer;

final class SimpleParameterRegistry
implements ParameterRegistry {
    private final HandlerRegistry<DataContainer, ParameterParser, ParameterSerializer> handlers = new HandlerRegistry();

    SimpleParameterRegistry() {
    }

    Registration registerParameterParser(int messageType, ParameterParser parser) {
        Preconditions.checkArgument((messageType >= 0 && messageType < 255 ? 1 : 0) != 0);
        return this.handlers.registerParser(messageType, (Object)parser);
    }

    Registration registerParameterSerializer(Class<? extends BgpParameters> paramClass, ParameterSerializer serializer) {
        return this.handlers.registerSerializer(paramClass, (Object)serializer);
    }

    @Override
    public Optional<ParameterParser> findParser(int parameterType) {
        return Optional.ofNullable(this.handlers.getParser(parameterType));
    }

    @Override
    public Optional<ParameterSerializer> findSerializer(BgpParameters parameter) {
        return Optional.ofNullable(this.handlers.getSerializer(parameter.implementedInterface()));
    }
}

